/*
 * Decompiled with CFR 0.152.
 */
package com.yao2san.sim.framework.utils.excelUtil;

import com.yao2san.sim.framework.utils.excelUtil.ExcelUtil;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class ReadExcelThread
implements Callable<List<Map<String, Object>>> {
    private Sheet sheet;
    private List<String> header;
    private int startRowIndex;
    private int endRowIndex;
    private ExcelUtil.Callback callback;
    List<Map<String, Object>> result;

    public ReadExcelThread(Sheet sheet, List<String> header, int startRowIndex, int endRowIndex, ExcelUtil.Callback callback) {
        this.sheet = sheet;
        this.header = header;
        this.startRowIndex = startRowIndex;
        this.endRowIndex = endRowIndex;
        this.callback = callback;
        this.result = new LinkedList<Map<String, Object>>();
    }

    @Override
    public List<Map<String, Object>> call() throws Exception {
        for (int index = this.startRowIndex; index < this.endRowIndex; ++index) {
            Row row = this.sheet.getRow(index);
            if (row.getRowNum() < this.startRowIndex) continue;
            Iterator cellIterator = row.cellIterator();
            LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
            while (cellIterator.hasNext()) {
                Cell cell = (Cell)cellIterator.next();
                Object value = "";
                CellType cellType = cell.getCellType();
                if (cellType == CellType.STRING) {
                    value = cell.getStringCellValue();
                }
                if (cellType == CellType.BOOLEAN) {
                    value = cell.getBooleanCellValue();
                }
                if (cellType == CellType.NUMERIC) {
                    value = BigDecimal.valueOf(cell.getNumericCellValue());
                }
                if (cellType == CellType.BLANK) {
                    value = "";
                }
                if (this.header == null) {
                    data.put("_COL_" + cell.getColumnIndex(), value);
                    continue;
                }
                data.put(this.header.get(cell.getColumnIndex()), value);
            }
            if (this.callback != null && this.callback.rowCallback(data)) {
                this.result.add(data);
                this.callback.rowCallback(data);
            }
            if (this.callback != null) continue;
            this.result.add(data);
        }
        return this.result;
    }
}

