/*
 * Decompiled with CFR 0.152.
 */
package com.yao2san.sim.framework.utils.excelUtil;

import com.yao2san.sim.framework.utils.excelUtil.ReadExcelThread;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ExcelUtil {
    public static List<Map<String, Object>> readAsList(String filePath, int sheetNum) throws IOException {
        return ExcelUtil.readAsList(new FileInputStream(filePath), sheetNum, null, 0, Integer.MAX_VALUE);
    }

    public static List<Map<String, Object>> readAsList(String filePath, int sheetNum, Callback callback) throws IOException {
        return ExcelUtil.readAsList(new FileInputStream(filePath), sheetNum, callback, 0, Integer.MAX_VALUE);
    }

    public static List<Map<String, Object>> readAsList(String filePath, int sheetNum, Callback callback, int startRowIndex) throws IOException {
        return ExcelUtil.readAsList(new FileInputStream(filePath), sheetNum, callback, startRowIndex, Integer.MAX_VALUE);
    }

    public static List<Map<String, Object>> readAsList(File file, int sheetNum) throws IOException {
        return ExcelUtil.readAsList(new FileInputStream(file), sheetNum, null, 0, Integer.MAX_VALUE);
    }

    public static List<Map<String, Object>> readAsList(File file, int sheetNum, Callback callback) throws IOException {
        return ExcelUtil.readAsList(new FileInputStream(file), sheetNum, callback, 0, Integer.MAX_VALUE);
    }

    public static List<Map<String, Object>> readAsList(File file, int sheetNum, Callback callback, int startRowIndex) throws IOException {
        return ExcelUtil.readAsList(new FileInputStream(file), sheetNum, callback, startRowIndex, Integer.MAX_VALUE);
    }

    public static List<Map<String, Object>> readAsList(InputStream inputStream, int sheetNum, Callback callback, int startRowIndex, int endRowIndex) throws IOException {
        LinkedList<Map<String, Object>> result = new LinkedList<Map<String, Object>>();
        try (Workbook wb = WorkbookFactory.create((InputStream)inputStream);){
            Sheet sheet = wb.getSheetAt(sheetNum);
            LinkedList<String> header = null;
            if (callback != null && callback.headerRowIndex() != -1) {
                Row row = sheet.getRow(callback.headerRowIndex());
                header = new LinkedList<String>();
                Iterator cellIterator = row.cellIterator();
                while (cellIterator.hasNext()) {
                    Cell cell = (Cell)cellIterator.next();
                    header.add(cell.getStringCellValue());
                }
            }
            Iterator rowIterator = sheet.rowIterator();
            while (rowIterator.hasNext()) {
                Row row = (Row)rowIterator.next();
                if (row.getRowNum() < startRowIndex || row.getRowNum() >= endRowIndex) continue;
                Iterator cellIterator = row.cellIterator();
                LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
                while (cellIterator.hasNext()) {
                    Cell cell = (Cell)cellIterator.next();
                    Object value = "";
                    CellType cellType = cell.getCellType();
                    if (cellType == CellType.STRING) {
                        value = cell.getStringCellValue();
                    }
                    if (cellType == CellType.BOOLEAN) {
                        value = cell.getBooleanCellValue();
                    }
                    if (cellType == CellType.NUMERIC) {
                        value = BigDecimal.valueOf(cell.getNumericCellValue());
                    }
                    if (cellType == CellType.BLANK) {
                        value = "";
                    }
                    if (header == null) {
                        data.put("_COL_" + cell.getColumnIndex(), value);
                        continue;
                    }
                    data.put((String)header.get(cell.getColumnIndex()), value);
                }
                if (callback != null && callback.rowCallback(data)) {
                    result.add(data);
                    callback.rowCallback(data);
                }
                if (callback != null) continue;
                result.add(data);
            }
        }
        return result;
    }

    public static List<Map<String, Object>> readAsList(File file, int sheetNum, int threads, Callback callback) throws IOException, ExecutionException, InterruptedException {
        LinkedList result = new LinkedList();
        try (Workbook wb = WorkbookFactory.create((File)file);){
            Sheet sheet = wb.getSheetAt(sheetNum);
            LinkedList<String> header = null;
            if (callback != null && callback.headerRowIndex() != -1) {
                Row row = sheet.getRow(callback.headerRowIndex());
                header = new LinkedList<String>();
                Iterator cellIterator = row.cellIterator();
                while (cellIterator.hasNext()) {
                    Cell cell = (Cell)cellIterator.next();
                    header.add(cell.getStringCellValue());
                }
            }
            ArrayList<FutureTask<List<Map<String, Object>>>> futureTasks = new ArrayList<FutureTask<List<Map<String, Object>>>>();
            int rowNum = sheet.getLastRowNum();
            int step = rowNum < threads ? 1 : rowNum / threads;
            for (int i = 0; i < threads; ++i) {
                if (i == threads - 1) {
                    futureTasks.add(new FutureTask<List<Map<String, Object>>>(new ReadExcelThread(sheet, header, step * i, rowNum, callback)));
                    continue;
                }
                futureTasks.add(new FutureTask<List<Map<String, Object>>>(new ReadExcelThread(sheet, header, step * i, step * (i + 1), callback)));
            }
            ExecutorService executorService = Executors.newFixedThreadPool(threads);
            for (FutureTask futureTask : futureTasks) {
                executorService.submit(futureTask);
            }
            for (FutureTask futureTask : futureTasks) {
                List list = (List)futureTask.get();
                result.addAll(list);
            }
            if (!executorService.isShutdown()) {
                executorService.shutdown();
            }
            wb.cloneSheet(sheetNum);
            LinkedList linkedList = result;
            return linkedList;
        }
    }

    public static interface Callback {
        default public boolean rowCallback(Map<String, Object> row) {
            return true;
        }

        default public int headerRowIndex() {
            return -1;
        }
    }
}

