/*
 * Decompiled with CFR 0.152.
 */
package com.yao2san.sim.framework.utils;

import cn.hutool.core.io.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class WebUtil {
    private static final Logger log = LoggerFactory.getLogger(WebUtil.class);
    private static final PathMatcher PATH_MATCHER = new AntPathMatcher();

    public static boolean mathUrl(String urlPattern, String url) {
        return PATH_MATCHER.match(urlPattern, url);
    }

    public static boolean mathUrl(String[] urlPatterns, String url) {
        if (urlPatterns == null) {
            throw new NullPointerException("urlPatterns can't be null");
        }
        for (String urlPattern : urlPatterns) {
            if (!PATH_MATCHER.match(urlPattern, url)) continue;
            return true;
        }
        return false;
    }

    public static boolean mathUrl(List<String> urlPatterns, String url) {
        if (urlPatterns == null) {
            throw new NullPointerException("urlPatterns can't be null");
        }
        for (String urlPattern : urlPatterns) {
            if (!PATH_MATCHER.match(urlPattern, url)) continue;
            return true;
        }
        return false;
    }

    public static void download(File file) {
        WebUtil.download(file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void download(File file, boolean isDelete) {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletResponse response = servletRequestAttributes.getResponse();
        if (response == null) {
            return;
        }
        FileInputStream inStream = null;
        try {
            int len;
            inStream = new FileInputStream(file);
            response.reset();
            response.setContentType("application/octet-stream");
            response.setCharacterEncoding("utf-8");
            response.addHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(FileUtil.getName((File)file), "utf-8"));
            byte[] buffer = new byte[1024];
            ServletOutputStream out = response.getOutputStream();
            while ((len = ((InputStream)inStream).read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
            out.flush();
            if (file.isFile() && isDelete) {
                FileUtils.deleteQuietly((File)file);
            }
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
            response.addHeader("error-msg", URLEncoder.encode("\u7cfb\u7edf\u5f02\u5e38:" + e.getMessage()));
        }
        finally {
            if (inStream != null) {
                try {
                    ((InputStream)inStream).close();
                }
                catch (IOException e) {
                    log.error("", (Throwable)e);
                }
            }
        }
    }

    public static String getHeader(String name) {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (servletRequestAttributes != null) {
            HttpServletRequest request = servletRequestAttributes.getRequest();
            return request.getHeader(name);
        }
        return null;
    }
}

