/*
 * Decompiled with CFR 0.152.
 */
package com.yao2san.sim.framework.utils;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class RequestUtil {
    public static final RestTemplate restTemplate = new RestTemplate();

    public static <T> T postForObject(String url, Object object, Class<T> clazz) {
        return RequestUtil.postForObject(url, object, MediaType.APPLICATION_JSON_UTF8, clazz);
    }

    public static <T> T postForObject(String url, Object object, MediaType mediaType, Class<T> clazz) {
        return (T)RequestUtil.postForEntity(url, object, mediaType, clazz).getBody();
    }

    public static <T> ResponseEntity<T> postForEntity(String url, Object object, MediaType mediaType, Class<T> clazz) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(mediaType);
        HttpEntity httpEntity = new HttpEntity(object, (MultiValueMap)headers);
        return restTemplate.postForEntity(url, (Object)httpEntity, clazz, new Object[0]);
    }

    public static <T> T getForObject(String url, Class<T> clazz) {
        return (T)RequestUtil.getForEntity(url, null, clazz).getBody();
    }

    public static <T> T getForObject(String url, Map<String, Object> urlParams, Class<T> clazz) {
        return (T)RequestUtil.getForEntity(url, urlParams, clazz).getBody();
    }

    public static <T> ResponseEntity<T> getForEntity(String url, Map<String, Object> urlParams, Class<T> clazz) {
        url = RequestUtil.builderUrl(url, urlParams);
        return restTemplate.getForEntity(url, clazz, new Object[0]);
    }

    private static String builderUrl(String url, Map<String, Object> params) {
        if (params != null) {
            url = ((String)url).endsWith("?") ? url : (String)url + "?";
            StringBuilder urlBuilder = new StringBuilder((String)url);
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                urlBuilder.append("&").append(entry.getKey()).append("=").append(entry.getValue()).append("&");
            }
            url = urlBuilder.toString();
            url = ((String)url).substring(0, ((String)url).length() - 1);
        }
        return url;
    }

    static {
        restTemplate.getMessageConverters().set(1, new StringHttpMessageConverter(StandardCharsets.UTF_8));
    }
}

