/*
 * Decompiled with CFR 0.152.
 */
package com.yao2san.sim.framework.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="sim.utils.email")
public class EmailUtil {
    private static final Logger log = LoggerFactory.getLogger(EmailUtil.class);
    private static String username;
    private static String password;
    private static String host;
    private static String port;
    private static String protocol;

    @Value(value="sim.utils.email.username")
    public void setUsername(String username) {
        EmailUtil.username = username;
    }

    @Value(value="sim.utils.email.host")
    public void setHost(String host) {
        EmailUtil.host = host;
    }

    @Value(value="sim.utils.email.password")
    public void setPassword(String password) {
        EmailUtil.password = password;
    }

    @Value(value="sim.utils.email.port:25")
    public void setPort(String port) {
        EmailUtil.port = port;
    }

    @Value(value="sim.utils.email.protocol:'SMTP'")
    public void setProtocol(String protocol) {
        EmailUtil.protocol = protocol;
    }

    public static Map<String, String> sendMail(String emailAddr, String title, String emailMsg) {
        HashMap<String, String> sendRes = new HashMap<String, String>();
        Properties props = new Properties();
        props.setProperty("mail.transport.protocol", protocol);
        props.setProperty("mail.host", host);
        props.setProperty("mail.smtp.auth", "true");
        props.setProperty("mail.smtp.port", port);
        props.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        props.setProperty("mail.smtp.socketFactory.port", "465");
        Authenticator auth = new Authenticator(){

            public PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(username, password);
            }
        };
        Session session = Session.getInstance((Properties)props, (Authenticator)auth);
        MimeMessage message = new MimeMessage(session);
        try {
            message.setFrom((Address)new InternetAddress(emailAddr));
            message.setRecipient(MimeMessage.RecipientType.TO, (Address)new InternetAddress(emailAddr));
            message.setSubject(title);
            message.setContent((Object)emailMsg, "text/html;charset=utf-8");
            Transport.send((Message)message);
            sendRes.put("status", "ok");
            sendRes.put("msg", "");
            return sendRes;
        }
        catch (MessagingException e) {
            log.error("\u53d1\u9001\u5931\u8d25", (Throwable)e);
            sendRes.put("status", "fail");
            sendRes.put("msg", "\u53d1\u9001\u5931\u8d25:" + e.getMessage());
            return sendRes;
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EmailUtil)) {
            return false;
        }
        EmailUtil other = (EmailUtil)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof EmailUtil;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "EmailUtil()";
    }
}

