/*
 * Decompiled with CFR 0.152.
 */
package com.yao2san.sim.framework.utils;

import cn.hutool.core.util.RandomUtil;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class CommonUtil {
    public static String getRandomString(int length) {
        if (length <= 0 || length >= 32) {
            return UUID.randomUUID().toString().replace("-", "").substring(0, 32);
        }
        return UUID.randomUUID().toString().replace("-", "").substring(0, length);
    }

    public static int getRandomInt(int len) {
        int digit = (int)Math.pow(10.0, len - 1);
        int rs = new Random().nextInt(digit * 10);
        if (rs < digit) {
            rs += digit;
        }
        return rs;
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }

    public static List<Map<Object, Object>> distinctMapByKey(List<Map<Object, Object>> list, String key) {
        ArrayList<Map<Object, Object>> copyList = new ArrayList();
        Collections.copy(copyList, list);
        copyList = list.stream().filter(CommonUtil.distinctByKey(m -> m.get(key))).collect(Collectors.toList());
        return copyList;
    }

    public static String getFileSuffix(String fileName) {
        int index = fileName.lastIndexOf(".");
        if (index == -1) {
            return "";
        }
        if (StringUtils.isNotEmpty((CharSequence)fileName)) {
            return fileName.substring(index + 1);
        }
        return "";
    }

    public static <T> List<T> memoryPagination(List<T> list, Integer pageNum, Integer pageSize) {
        int toIndex;
        int fromIndex;
        if (list == null) {
            return null;
        }
        if (list.size() == 0) {
            return null;
        }
        if (pageNum <= 0) {
            return null;
        }
        if (pageSize <= 0) {
            throw new IllegalArgumentException("pageSize must greater than 0");
        }
        Integer count = list.size();
        Integer pageCount = count % pageSize == 0 ? Integer.valueOf(count / pageSize) : Integer.valueOf(count / pageSize + 1);
        if (pageNum > pageCount) {
            pageNum = pageCount;
        }
        if (!pageNum.equals(pageCount)) {
            fromIndex = (pageNum - 1) * pageSize;
            toIndex = fromIndex + pageSize;
        } else {
            fromIndex = (pageNum - 1) * pageSize;
            toIndex = count;
        }
        return list.subList(fromIndex, toIndex);
    }

    public static String md5(String string) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] bytes = md5.digest(string.getBytes(StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder();
            for (byte b : bytes) {
                sb.append(String.format("%02x", b));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String formatPath(String path) {
        return path.replaceAll("(/+|\\\\+)+", "/");
    }

    public static String getPath(String pathName) {
        return pathName.substring(0, pathName.lastIndexOf("/"));
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("windows");
    }

    public static String requestId() {
        return new BigInteger(System.currentTimeMillis() + RandomUtil.randomNumbers((int)5)).toString(16);
    }
}

