/*
 * Decompiled with CFR 0.152.
 */
package com.yao2san.sim.framework.log.aspect;

import com.yao2san.sim.framework.log.annotation.PrintLog;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
public class PrintLogAspect {
    private static final Logger log = LoggerFactory.getLogger(PrintLogAspect.class);
    @Value(value="${spring.application.name:'application'}")
    private String appName;

    @Pointcut(value="@annotation(com.yao2san.sim.framework.log.annotation.PrintLog)")
    public void pointcut() {
    }

    @Around(value="pointcut()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        Signature signature = joinPoint.getSignature();
        Method method = ((MethodSignature)signature).getMethod();
        PrintLog annotation = method.getAnnotation(PrintLog.class);
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        assert (attributes != null);
        HttpServletRequest request = attributes.getRequest();
        log.info("name={},url={},method={},ip={},class_method={},args={}", new Object[]{annotation.value(), request.getRequestURI(), request.getMethod(), request.getRemoteAddr(), signature.getDeclaringTypeName() + "#" + signature.getName(), joinPoint.getArgs()});
        Long start = System.currentTimeMillis();
        Object proceed = joinPoint.proceed();
        Long end = System.currentTimeMillis();
        if (annotation.useTimer()) {
            log.info("name={},time={}ms", (Object)annotation.value(), (Object)(end - start));
        }
        return proceed;
    }
}

