package com.swjtu.android.androidutil;

import android.view.View;
import android.view.View.MeasureSpec;

/**
 * @author 杨海鹏
 */

public class ViewUtil {

  /**
   * 得到实际的尺寸
   *
   * @param SizeInfoMeasureSpec 宽还是高()
   * @param defaultSize 要求的尺寸
   */
  public static int getSize(int SizeInfoMeasureSpec, int defaultSize) {

    int mode = MeasureSpec.getMode(SizeInfoMeasureSpec);
    int size = defaultSize;
    switch (mode) {
      case MeasureSpec.EXACTLY: {
        size = MeasureSpec.getSize(SizeInfoMeasureSpec);
      }
      break;
      case MeasureSpec.AT_MOST: {
        size = Math.min(size, View.MeasureSpec.getSize(SizeInfoMeasureSpec));
      }
      break;
      default: {
        size = defaultSize;
      }
      break;
    }
    return size;
  }
}
