/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.maha.api.example;

import com.yahoo.maha.api.example.ExampleMahaService$;
import com.yahoo.maha.core.BaseTable;
import com.yahoo.maha.core.ddl.OracleDDLGenerator;
import com.yahoo.maha.core.fact.Fact;
import com.yahoo.maha.core.fact.PublicFact;
import com.yahoo.maha.core.registry.Registry;
import com.yahoo.maha.jdbc.JdbcConnection;
import com.yahoo.maha.jdbc.JdbcConnection$;
import com.yahoo.maha.jdbc.package$;
import com.yahoo.maha.service.DefaultMahaService;
import com.yahoo.maha.service.MahaService;
import com.yahoo.maha.service.MahaServiceConfig;
import com.yahoo.maha.service.MahaServiceConfig$;
import com.yahoo.maha.service.RegistryConfig;
import com.yahoo.maha.service.error.MahaServiceError;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.File;
import java.sql.ResultSet;
import java.util.UUID;
import javax.sql.DataSource;
import org.apache.commons.io.FileUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.util.Try;
import scalaz.NonEmptyList;
import scalaz.Validation;

public final class ExampleMahaService$
implements Logging {
    public static final ExampleMahaService$ MODULE$;
    private Option<HikariDataSource> dataSource;
    private Option<JdbcConnection> com$yahoo$maha$api$example$ExampleMahaService$$jdbcConnection;
    private final String h2dbId;
    private final String today;
    private final String yesterday;
    private final transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new ExampleMahaService$();
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ExampleMahaService$ exampleMahaService$ = this;
        synchronized (exampleMahaService$) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.class.grizzled$slf4j$Logging$$_logger((Logging)this);
                this.bitmap$trans$0 = true;
            }
            return this.grizzled$slf4j$Logging$$_logger;
        }
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger : this.grizzled$slf4j$Logging$$_logger$lzycompute();
    }

    public Logger logger() {
        return Logging.class.logger((Logging)this);
    }

    public String loggerName() {
        return Logging.class.loggerName((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.trace((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.trace((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.debug((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.debug((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.class.isErrorEnabled((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.error((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.error((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.class.isInfoEnabled((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.info((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.info((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.class.isWarnEnabled((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.warn((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.warn((Logging)this, (Marker)mkr, msg, t);
    }

    private Option<HikariDataSource> dataSource() {
        return this.dataSource;
    }

    private void dataSource_$eq(Option<HikariDataSource> x$1) {
        this.dataSource = x$1;
    }

    public Option<JdbcConnection> com$yahoo$maha$api$example$ExampleMahaService$$jdbcConnection() {
        return this.com$yahoo$maha$api$example$ExampleMahaService$$jdbcConnection;
    }

    private void com$yahoo$maha$api$example$ExampleMahaService$$jdbcConnection_$eq(Option<JdbcConnection> x$1) {
        this.com$yahoo$maha$api$example$ExampleMahaService$$jdbcConnection = x$1;
    }

    public String h2dbId() {
        return this.h2dbId;
    }

    public String today() {
        return this.today;
    }

    public String yesterday() {
        return this.yesterday;
    }

    public void initJdbcToH2() {
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"jdbc:h2:mem:", ";MODE=Oracle;DB_CLOSE_DELAY=-1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.h2dbId()})));
        config.setUsername("sa");
        config.setPassword("h2.test.database.password");
        config.setMaximumPoolSize(2);
        this.dataSource_$eq((Option<HikariDataSource>)Option$.MODULE$.apply((Object)new HikariDataSource(config)));
        this.com$yahoo$maha$api$example$ExampleMahaService$$jdbcConnection_$eq((Option<JdbcConnection>)this.dataSource().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JdbcConnection apply(HikariDataSource x$1) {
                return new JdbcConnection((DataSource)x$1, JdbcConnection$.MODULE$.$lessinit$greater$default$2());
            }
        }));
        Predef$.MODULE$.assert(this.com$yahoo$maha$api$example$ExampleMahaService$$jdbcConnection().isDefined(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Failed to connect to h2 local server";
            }
        });
    }

    public MahaService getMahaService(String scope) {
        String jsonString = FileUtils.readFileToString((File)new File(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"src/", "/resources/maha-service-config.json"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{scope})))).replaceAll("h2dbId", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.h2dbId()})));
        this.initJdbcToH2();
        Validation mahaServiceResult = MahaServiceConfig$.MODULE$.fromJson(jsonString.getBytes("utf-8"));
        Object object = mahaServiceResult.isFailure() ? mahaServiceResult.leftMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(NonEmptyList<MahaServiceError> res) {
                ExampleMahaService$.MODULE$.error((Function0<Object>)new Serializable(this, res){
                    public static final long serialVersionUID = 0L;
                    private final NonEmptyList res$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to launch Example MahaService, MahaService Error list is: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.res$1.list().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<String, Option<Throwable>> apply(MahaServiceError er) {
                                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)er.message()), (Object)er.source());
                            }
                        }).toList()}));
                    }
                    {
                        this.res$1 = res$1;
                    }
                });
            }
        }) : BoxedUnit.UNIT;
        MahaServiceConfig mahaServiceConfig = (MahaServiceConfig)mahaServiceResult.toOption().get();
        DefaultMahaService mahaService = new DefaultMahaService(mahaServiceConfig);
        this.stageStudentData(mahaServiceConfig);
        return mahaService;
    }

    public String getMahaService$default$1() {
        return "main";
    }

    public void stageStudentData(MahaServiceConfig mahaServiceConfig) {
        OracleDDLGenerator ddlGenerator = new OracleDDLGenerator();
        RegistryConfig erRegistryConfig = (RegistryConfig)mahaServiceConfig.registry().get((Object)"student").get();
        Registry erRegistry = erRegistryConfig.registry();
        erRegistry.factMap().values().foreach((Function1)new Serializable(ddlGenerator){
            public static final long serialVersionUID = 0L;
            public final OracleDDLGenerator ddlGenerator$1;

            public final void apply(PublicFact publicFact) {
                publicFact.factList().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.stageStudentData.1 $outer;

                    public final void apply(Fact fact) {
                        String ddl = this.$outer.ddlGenerator$1.toDDL((BaseTable)fact);
                        Predef$.MODULE$.assert(((JdbcConnection)ExampleMahaService$.MODULE$.com$yahoo$maha$api$example$ExampleMahaService$$jdbcConnection().get()).executeUpdate(ddl).isSuccess());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.ddlGenerator$1 = ddlGenerator$1;
            }
        });
        String insertSql = "\n        INSERT INTO student_grade_sheet (year, section_id, student_id, class_id, total_marks, date, comment)\n        VALUES (?, ?, ?, ?, ?, ?, ?)\n      ";
        List rows = package$.MODULE$.List().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Seq[]{(scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)100), BoxesRunTime.boxToInteger((int)213), BoxesRunTime.boxToInteger((int)200), BoxesRunTime.boxToInteger((int)125), "2017-10-25", "some comment"}))}));
        rows.foreach((Function1)new Serializable(insertSql){
            public static final long serialVersionUID = 0L;
            private final String insertSql$1;

            public final void apply(scala.collection.immutable.Seq<Object> row) {
                Try result = ((JdbcConnection)ExampleMahaService$.MODULE$.com$yahoo$maha$api$example$ExampleMahaService$$jdbcConnection().get()).executeUpdate(this.insertSql$1, row);
                Predef$.MODULE$.assert(result.isSuccess());
            }
            {
                this.insertSql$1 = insertSql$1;
            }
        });
        IntRef count = IntRef.create((int)0);
        ((JdbcConnection)this.com$yahoo$maha$api$example$ExampleMahaService$$jdbcConnection().get()).queryForObject("select * from student_grade_sheet", (Function1)new Serializable(count){
            public static final long serialVersionUID = 0L;
            private final IntRef count$1;

            public final void apply(ResultSet rs) {
                while (rs.next()) {
                    ++this.count$1.elem;
                }
            }
            {
                this.count$1 = count$1;
            }
        });
        Predef$.MODULE$.assert(rows.size() == count.elem);
    }

    private ExampleMahaService$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.dataSource = None$.MODULE$;
        this.com$yahoo$maha$api$example$ExampleMahaService$$jdbcConnection = None$.MODULE$;
        this.h2dbId = UUID.randomUUID().toString().replace("-", "");
        this.today = DateTimeFormat.forPattern((String)"yyyy-MM-dd").print((ReadableInstant)DateTime.now());
        this.yesterday = DateTimeFormat.forPattern((String)"yyyy-MM-dd").print((ReadableInstant)DateTime.now().minusDays(1));
    }
}

