/*
 * Decompiled with CFR 0.152.
 */
package com.xzixi.util.sftp.client.component;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.xzixi.util.sftp.client.exception.SftpClientException;
import com.xzixi.util.sftp.client.util.ByteUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class Sftp {
    private ChannelSftp channelSftp;

    public InputStream getInputStream(String dir, String name) {
        if (!this.isExist(dir)) {
            throw new SftpClientException(String.format("\u76ee\u5f55(%s)\u4e0d\u5b58\u5728\uff01", dir));
        }
        String absoluteFilePath = dir + "/" + name;
        if (!this.isExist(absoluteFilePath)) {
            throw new SftpClientException(String.format("\u6587\u4ef6(%s)\u4e0d\u5b58\u5728\uff01", absoluteFilePath));
        }
        try {
            this.channelSftp.cd(dir);
            return this.channelSftp.get(name);
        }
        catch (SftpException e) {
            throw new SftpClientException("sftp\u83b7\u53d6\u8fdc\u7a0b\u6587\u4ef6\u8f93\u5165\u6d41\u9519\u8bef", e);
        }
    }

    public byte[] download(String dir, String name) {
        InputStream in = this.getInputStream(dir, name);
        return ByteUtil.inputStreamToByteArray(in);
    }

    public void upload(String dir, String name, InputStream in) {
        try {
            this.mkdirs(dir);
            this.channelSftp.cd(dir);
            this.channelSftp.put(in, name);
        }
        catch (SftpException e) {
            throw new SftpClientException("sftp\u4e0a\u4f20\u6587\u4ef6\u51fa\u9519", e);
        }
    }

    public void upload(String dir, String name, String src) {
        try {
            this.mkdirs(dir);
            this.channelSftp.cd(dir);
            this.channelSftp.put(src, name);
        }
        catch (SftpException e) {
            throw new SftpClientException("sftp\u4e0a\u4f20\u6587\u4ef6\u51fa\u9519", e);
        }
    }

    public void delete(String dir) {
        if (!this.isDir(dir)) {
            return;
        }
        if (!this.isExist(dir)) {
            return;
        }
        try {
            this.channelSftp.rmdir(dir);
        }
        catch (SftpException e) {
            throw new SftpClientException("sftp\u5220\u9664\u76ee\u5f55\u51fa\u9519", e);
        }
    }

    public void delete(String dir, String name) {
        if (!this.isDir(dir)) {
            return;
        }
        String absoluteFilePath = dir + "/" + name;
        if (!this.isExist(absoluteFilePath)) {
            return;
        }
        try {
            this.channelSftp.cd(dir);
            this.channelSftp.rm(name);
        }
        catch (SftpException e) {
            throw new SftpClientException("sftp\u5220\u9664\u6587\u4ef6\u51fa\u9519", e);
        }
    }

    public void mkdirs(String dir) {
        String[] folders = dir.split("/");
        try {
            this.channelSftp.cd("/");
            for (String folder : folders) {
                if (folder.length() <= 0) continue;
                try {
                    this.channelSftp.cd(folder);
                }
                catch (Exception e) {
                    this.channelSftp.mkdir(folder);
                    this.channelSftp.cd(folder);
                }
            }
        }
        catch (SftpException e) {
            throw new SftpClientException("sftp\u521b\u5efa\u76ee\u5f55\u51fa\u9519", e);
        }
    }

    public boolean isExist(String path) {
        try {
            this.channelSftp.lstat(path);
            return true;
        }
        catch (SftpException e) {
            return false;
        }
    }

    public boolean isDir(String path) {
        try {
            SftpATTRS attrs = this.channelSftp.lstat(path);
            return attrs.isDir();
        }
        catch (SftpException e) {
            return false;
        }
    }

    public List<String> list(String path) {
        ArrayList<String> result = new ArrayList<String>();
        ChannelSftp.LsEntrySelector selector = lsEntry -> {
            String filename = lsEntry.getFilename();
            if (!".".equals(filename) && !"..".equals(filename)) {
                result.add(filename);
            }
            return 0;
        };
        try {
            this.channelSftp.ls(path, selector);
        }
        catch (SftpException e) {
            throw new SftpClientException("sftp\u67e5\u770b\u76ee\u5f55\u51fa\u9519", e);
        }
        return result;
    }

    public void move(String src, String target) {
        try {
            this.channelSftp.rename(src, target);
        }
        catch (SftpException e) {
            throw new SftpClientException("sftp\u79fb\u52a8\u6587\u4ef6\u51fa\u9519", e);
        }
    }

    public void chmod(String permissions, String path) {
        if (permissions == null) {
            throw new SftpClientException("\u6743\u9650\u4e0d\u80fd\u4e3anull");
        }
        if (permissions.length() != 3) {
            throw new SftpClientException("\u6743\u9650\u5fc5\u987b\u662f3\u4f4d0-7\u7684\u6570\u5b57");
        }
        for (char c : permissions.toCharArray()) {
            int i;
            try {
                i = Integer.parseInt(String.valueOf(c));
            }
            catch (NumberFormatException e) {
                throw new SftpClientException("\u6743\u9650\u5fc5\u987b\u662f3\u4f4d0-7\u7684\u6570\u5b57");
            }
            if (i <= 7 && i >= 0) continue;
            throw new SftpClientException("\u6743\u9650\u5fc5\u987b\u662f3\u4f4d0-7\u7684\u6570\u5b57");
        }
        Integer p = Integer.valueOf(permissions, 8);
        try {
            this.channelSftp.chmod(p.intValue(), path);
        }
        catch (SftpException e) {
            throw new SftpClientException("sftp\u4fee\u6539\u6743\u9650\u51fa\u9519", e);
        }
    }

    public ChannelSftp getChannelSftp() {
        return this.channelSftp;
    }

    public void setChannelSftp(ChannelSftp channelSftp) {
        this.channelSftp = channelSftp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Sftp)) {
            return false;
        }
        Sftp other = (Sftp)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ChannelSftp this$channelSftp = this.getChannelSftp();
        ChannelSftp other$channelSftp = other.getChannelSftp();
        return !(this$channelSftp == null ? other$channelSftp != null : !this$channelSftp.equals(other$channelSftp));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Sftp;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ChannelSftp $channelSftp = this.getChannelSftp();
        result = result * 59 + ($channelSftp == null ? 43 : $channelSftp.hashCode());
        return result;
    }

    public String toString() {
        return "Sftp(channelSftp=" + this.getChannelSftp() + ")";
    }

    public Sftp() {
    }

    public Sftp(ChannelSftp channelSftp) {
        this.channelSftp = channelSftp;
    }
}

