/*
 * Decompiled with CFR 0.152.
 */
package com.xzixi.util.sftp.client.component;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.xzixi.util.sftp.client.component.Sftp;
import com.xzixi.util.sftp.client.exception.SftpClientException;
import java.util.Properties;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;

public class SftpFactory
extends BasePooledObjectFactory<Sftp> {
    private static final String CHANNEL_TYPE = "sftp";
    private static Properties sshConfig = new Properties();
    private String host;
    private int port;
    private String username;
    private String password;

    public Sftp create() {
        try {
            JSch jsch = new JSch();
            Session sshSession = jsch.getSession(this.username, this.host, this.port);
            sshSession.setPassword(this.password);
            sshSession.setConfig(sshConfig);
            sshSession.connect();
            ChannelSftp channel = (ChannelSftp)sshSession.openChannel(CHANNEL_TYPE);
            channel.connect();
            return new Sftp(channel);
        }
        catch (JSchException e) {
            throw new SftpClientException("\u8fde\u63a5sftp\u5931\u8d25", e);
        }
    }

    public PooledObject<Sftp> wrap(Sftp sftp) {
        return new DefaultPooledObject((Object)sftp);
    }

    public void destroyObject(PooledObject<Sftp> p) {
        ChannelSftp channelSftp;
        Sftp sftp;
        if (p != null && (sftp = (Sftp)p.getObject()) != null && (channelSftp = sftp.getChannelSftp()) != null) {
            channelSftp.disconnect();
        }
    }

    public boolean validateObject(PooledObject<Sftp> p) {
        Sftp sftp;
        if (p != null && (sftp = (Sftp)p.getObject()) != null) {
            try {
                sftp.getChannelSftp().pwd();
                return true;
            }
            catch (SftpException e) {
                return false;
            }
        }
        return false;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String toString() {
        return "SftpFactory(host=" + this.getHost() + ", port=" + this.getPort() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SftpFactory)) {
            return false;
        }
        SftpFactory other = (SftpFactory)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SftpFactory;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        result = result * 59 + this.getPort();
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }

    public SftpFactory() {
    }

    public SftpFactory(String host, int port, String username, String password) {
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
    }

    static {
        sshConfig.put("StrictHostKeyChecking", "no");
    }

    public static class Builder {
        private String host;
        private int port;
        private String username;
        private String password;

        public SftpFactory build() {
            return new SftpFactory(this.host, this.port, this.username, this.password);
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }
    }
}

