/*
 * Decompiled with CFR 0.152.
 */
package com.xzixi.util.sftp.client.component;

import com.xzixi.util.sftp.client.component.ISftpClient;
import com.xzixi.util.sftp.client.component.Sftp;
import com.xzixi.util.sftp.client.component.SftpPool;
import com.xzixi.util.sftp.client.exception.SftpClientException;

public class SftpClient
implements ISftpClient {
    private SftpPool sftpPool;

    @Override
    public void open(ISftpClient.Handler handler) {
        Sftp sftp = null;
        try {
            sftp = (Sftp)this.sftpPool.borrowObject();
            DelegateHandler policyHandler = new DelegateHandler(handler);
            policyHandler.doHandle(sftp);
        }
        catch (SftpClientException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SftpClientException("\u83b7\u53d6sftp\u8fde\u63a5\u51fa\u9519\uff01", e);
        }
        finally {
            if (sftp != null) {
                this.sftpPool.returnObject(sftp);
            }
        }
    }

    public SftpPool getSftpPool() {
        return this.sftpPool;
    }

    public void setSftpPool(SftpPool sftpPool) {
        this.sftpPool = sftpPool;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SftpClient)) {
            return false;
        }
        SftpClient other = (SftpClient)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SftpPool this$sftpPool = this.getSftpPool();
        SftpPool other$sftpPool = other.getSftpPool();
        return !(this$sftpPool == null ? other$sftpPool != null : !((Object)((Object)this$sftpPool)).equals((Object)other$sftpPool));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SftpClient;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SftpPool $sftpPool = this.getSftpPool();
        result = result * 59 + ($sftpPool == null ? 43 : ((Object)((Object)$sftpPool)).hashCode());
        return result;
    }

    public String toString() {
        return "SftpClient(sftpPool=" + (Object)((Object)this.getSftpPool()) + ")";
    }

    public SftpClient() {
    }

    public SftpClient(SftpPool sftpPool) {
        this.sftpPool = sftpPool;
    }

    static class DelegateHandler
    implements ISftpClient.Handler {
        private ISftpClient.Handler target;

        @Override
        public void doHandle(Sftp sftp) {
            try {
                this.target.doHandle(sftp);
            }
            catch (Exception e) {
                throw new SftpClientException("\u6267\u884csftp\u64cd\u4f5c\u51fa\u9519\uff01", e);
            }
        }

        public DelegateHandler(ISftpClient.Handler target) {
            this.target = target;
        }
    }
}

