/*
 * Decompiled with CFR 0.152.
 */
package com.xzixi.websocket.interceptablewebsocket.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xzixi.websocket.interceptablewebsocket.exception.InterceptableWebsocketException;
import java.io.IOException;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.ConcurrentWebSocketSessionDecorator;

@Component
public class NotifyUtil {
    private ObjectMapper objectMapper = new ObjectMapper();

    public void sendMessage(WebSocketSession session, Object message) {
        String content;
        if (message == null) {
            return;
        }
        if (message instanceof String) {
            content = message.toString();
        } else {
            try {
                content = this.objectMapper.writeValueAsString(message);
            }
            catch (JsonProcessingException e) {
                throw new InterceptableWebsocketException("json\u8f6c\u6362\u51fa\u9519", e);
            }
        }
        ConcurrentWebSocketSessionDecorator decorator = new ConcurrentWebSocketSessionDecorator(session, -1, -1);
        try {
            decorator.sendMessage((WebSocketMessage)new TextMessage((CharSequence)(" " + content)));
        }
        catch (IOException e) {
            throw new InterceptableWebsocketException("\u53d1\u9001\u6d88\u606f\u51fa\u9519", e);
        }
    }
}

