/*
 * Decompiled with CFR 0.152.
 */
package com.xzixi.websocket.interceptablewebsocket.extension;

import com.xzixi.websocket.interceptablewebsocket.exception.InterceptableWebsocketException;
import com.xzixi.websocket.interceptablewebsocket.extension.InterceptableStompSubProtocolHandler;
import com.xzixi.websocket.interceptablewebsocket.interceptor.FromClientInterceptor;
import com.xzixi.websocket.interceptablewebsocket.interceptor.ToClientInterceptor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.MultiValueMap;
import org.springframework.web.servlet.handler.AbstractHandlerMapping;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.StompWebSocketEndpointRegistration;
import org.springframework.web.socket.config.annotation.WebMvcStompEndpointRegistry;
import org.springframework.web.socket.config.annotation.WebMvcStompWebSocketEndpointRegistration;
import org.springframework.web.socket.config.annotation.WebSocketTransportRegistration;
import org.springframework.web.socket.handler.WebSocketHandlerDecorator;
import org.springframework.web.socket.messaging.StompSubProtocolErrorHandler;
import org.springframework.web.socket.messaging.SubProtocolHandler;
import org.springframework.web.socket.messaging.SubProtocolWebSocketHandler;
import org.springframework.web.socket.server.support.WebSocketHandlerMapping;
import org.springframework.web.util.UrlPathHelper;

public class InterceptableWebMvcStompEndpointRegistry
extends WebMvcStompEndpointRegistry {
    private static final Logger log = LoggerFactory.getLogger(InterceptableWebMvcStompEndpointRegistry.class);
    private final WebSocketHandler webSocketHandler;
    private final TaskScheduler sockJsScheduler;
    private int order = 1;
    @Nullable
    private UrlPathHelper urlPathHelper;
    private final SubProtocolWebSocketHandler subProtocolWebSocketHandler;
    private final InterceptableStompSubProtocolHandler stompHandler;
    private final List<WebMvcStompWebSocketEndpointRegistration> registrations = new ArrayList<WebMvcStompWebSocketEndpointRegistration>();

    public InterceptableWebMvcStompEndpointRegistry(WebSocketHandler webSocketHandler, WebSocketTransportRegistration transportRegistration, TaskScheduler defaultSockJsTaskScheduler) {
        super(webSocketHandler, transportRegistration, defaultSockJsTaskScheduler);
        this.webSocketHandler = webSocketHandler;
        this.subProtocolWebSocketHandler = InterceptableWebMvcStompEndpointRegistry.unwrapSubProtocolWebSocketHandler(webSocketHandler);
        Integer sendTimeLimit = InterceptableWebMvcStompEndpointRegistry.getTransportRegistrationValue(transportRegistration, "sendTimeLimit");
        Integer sendBufferSizeLimit = InterceptableWebMvcStompEndpointRegistry.getTransportRegistrationValue(transportRegistration, "sendBufferSizeLimit");
        Integer timeToFirstMessage = InterceptableWebMvcStompEndpointRegistry.getTransportRegistrationValue(transportRegistration, "timeToFirstMessage");
        Integer messageSizeLimit = InterceptableWebMvcStompEndpointRegistry.getTransportRegistrationValue(transportRegistration, "messageSizeLimit");
        if (sendTimeLimit != null) {
            this.subProtocolWebSocketHandler.setSendTimeLimit(sendTimeLimit.intValue());
        }
        if (sendBufferSizeLimit != null) {
            this.subProtocolWebSocketHandler.setSendBufferSizeLimit(sendBufferSizeLimit.intValue());
        }
        if (timeToFirstMessage != null) {
            this.subProtocolWebSocketHandler.setTimeToFirstMessage(timeToFirstMessage.intValue());
        }
        this.stompHandler = new InterceptableStompSubProtocolHandler();
        if (messageSizeLimit != null) {
            this.stompHandler.setMessageSizeLimit(messageSizeLimit);
        }
        this.sockJsScheduler = defaultSockJsTaskScheduler;
    }

    private static SubProtocolWebSocketHandler unwrapSubProtocolWebSocketHandler(WebSocketHandler handler) {
        WebSocketHandler actual = WebSocketHandlerDecorator.unwrap((WebSocketHandler)handler);
        if (!(actual instanceof SubProtocolWebSocketHandler)) {
            throw new IllegalArgumentException("No SubProtocolWebSocketHandler in " + handler);
        }
        return (SubProtocolWebSocketHandler)actual;
    }

    public StompWebSocketEndpointRegistration addEndpoint(String ... paths) {
        this.subProtocolWebSocketHandler.addProtocolHandler((SubProtocolHandler)this.stompHandler);
        WebMvcStompWebSocketEndpointRegistration registration = new WebMvcStompWebSocketEndpointRegistration(paths, this.webSocketHandler, this.sockJsScheduler);
        this.registrations.add(registration);
        return registration;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    protected int getOrder() {
        return this.order;
    }

    public void setUrlPathHelper(@Nullable UrlPathHelper urlPathHelper) {
        this.urlPathHelper = urlPathHelper;
    }

    @Nullable
    protected UrlPathHelper getUrlPathHelper() {
        return this.urlPathHelper;
    }

    public InterceptableWebMvcStompEndpointRegistry setErrorHandler(StompSubProtocolErrorHandler errorHandler) {
        this.stompHandler.setErrorHandler(errorHandler);
        return this;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        super.setApplicationContext(applicationContext);
    }

    public AbstractHandlerMapping getHandlerMapping() {
        LinkedHashMap urlMap = new LinkedHashMap();
        for (WebMvcStompWebSocketEndpointRegistration registration : this.registrations) {
            MultiValueMap mappings = registration.getMappings();
            mappings.forEach((httpHandler, patterns) -> {
                for (String pattern : patterns) {
                    urlMap.put(pattern, httpHandler);
                }
            });
        }
        WebSocketHandlerMapping hm = new WebSocketHandlerMapping();
        hm.setUrlMap(urlMap);
        hm.setOrder(this.order);
        if (this.urlPathHelper != null) {
            hm.setUrlPathHelper(this.urlPathHelper);
        }
        return hm;
    }

    public InterceptableWebMvcStompEndpointRegistry addFromClientInterceptor(FromClientInterceptor interceptor) {
        this.stompHandler.addFromClientInterceptor(interceptor);
        return this;
    }

    public InterceptableWebMvcStompEndpointRegistry addToClientInterceptor(ToClientInterceptor interceptor) {
        this.stompHandler.addToClientInterceptor(interceptor);
        return this;
    }

    private static Integer getTransportRegistrationValue(WebSocketTransportRegistration transportRegistration, String fieldName) {
        Integer ret = null;
        try {
            Field limitField = WebSocketTransportRegistration.class.getDeclaredField(fieldName);
            limitField.setAccessible(true);
            Object value = limitField.get(transportRegistration);
            if (value != null) {
                ret = (Integer)value;
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new InterceptableWebsocketException("\u83b7\u53d6" + fieldName + "\u7684\u503c\u51fa\u9519", e);
        }
        return ret;
    }
}

