/*
 * Decompiled with CFR 0.152.
 */
package com.xzixi.websocket.interceptablewebsocket.interceptor;

import com.xzixi.websocket.interceptablewebsocket.interceptor.ToClientInterceptor;
import java.util.List;
import org.springframework.messaging.simp.stomp.StompHeaderAccessor;
import org.springframework.security.core.Authentication;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.messaging.StompSubProtocolHandler;

public class ToClientExecutionChain {
    private List<ToClientInterceptor> interceptors;
    private int interceptorIndex = -1;

    public ToClientExecutionChain(List<ToClientInterceptor> interceptors) {
        Assert.notNull(interceptors, (String)"interceptors\u4e0d\u80fd\u4e3anull");
        this.interceptors = interceptors;
    }

    public boolean applyPreHandle(WebSocketSession session, Authentication authentication, StompHeaderAccessor accessor, Object payload, StompSubProtocolHandler handler) {
        if (!ObjectUtils.isEmpty(this.interceptors)) {
            int i = 0;
            while (i < this.interceptors.size()) {
                ToClientInterceptor interceptor = this.interceptors.get(i);
                if (!interceptor.preHandle(session, authentication, accessor, payload, handler)) {
                    this.applyPostHandle(session, authentication, accessor, payload, handler);
                    return false;
                }
                this.interceptorIndex = i++;
            }
        }
        return true;
    }

    public void applyPostHandle(WebSocketSession session, Authentication authentication, StompHeaderAccessor accessor, Object payload, StompSubProtocolHandler handler) {
        if (!ObjectUtils.isEmpty(this.interceptors)) {
            for (int i = this.interceptorIndex; i >= 0; --i) {
                ToClientInterceptor interceptor = this.interceptors.get(i);
                interceptor.postHandle(session, authentication, accessor, payload, handler);
            }
        }
    }
}

