/*
 * Decompiled with CFR 0.152.
 */
package com.xzixi.websocket.interceptablewebsocket.interceptor;

import com.xzixi.websocket.interceptablewebsocket.interceptor.FromClientInterceptor;
import com.xzixi.websocket.interceptablewebsocket.util.MessageFromClient;
import java.util.List;
import org.springframework.messaging.MessageChannel;
import org.springframework.security.core.Authentication;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.messaging.StompSubProtocolHandler;

public class FromClientExecutionChain {
    private List<FromClientInterceptor> interceptors;
    private int interceptorIndex = -1;

    public FromClientExecutionChain(List<FromClientInterceptor> interceptors) {
        Assert.notNull(interceptors, (String)"interceptors\u4e0d\u80fd\u4e3anull");
        this.interceptors = interceptors;
    }

    public boolean applyPreHandle(WebSocketSession session, Authentication authentication, MessageFromClient message, MessageChannel outputChannel, StompSubProtocolHandler handler) {
        if (!ObjectUtils.isEmpty(this.interceptors)) {
            int i = 0;
            while (i < this.interceptors.size()) {
                FromClientInterceptor interceptor = this.interceptors.get(i);
                if (!interceptor.preHandle(session, authentication, message, outputChannel, handler)) {
                    this.applyPostHandle(session, authentication, message, outputChannel, handler);
                    return false;
                }
                this.interceptorIndex = i++;
            }
        }
        return true;
    }

    public void applyPostHandle(WebSocketSession session, Authentication authentication, MessageFromClient message, MessageChannel outputChannel, StompSubProtocolHandler handler) {
        if (!ObjectUtils.isEmpty(this.interceptors)) {
            for (int i = this.interceptorIndex; i >= 0; --i) {
                FromClientInterceptor interceptor = this.interceptors.get(i);
                interceptor.postHandle(session, authentication, message, outputChannel, handler);
            }
        }
    }
}

