/*
 * Decompiled with CFR 0.152.
 */
package com.xzixi.websocket.interceptablewebsocket.extension;

import com.xzixi.websocket.interceptablewebsocket.interceptor.FromClientExecutionChain;
import com.xzixi.websocket.interceptablewebsocket.interceptor.FromClientInterceptor;
import com.xzixi.websocket.interceptablewebsocket.interceptor.ToClientExecutionChain;
import com.xzixi.websocket.interceptablewebsocket.interceptor.ToClientInterceptor;
import com.xzixi.websocket.interceptablewebsocket.util.MessageFromClient;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedTransferQueue;
import org.apache.commons.lang3.StringUtils;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.simp.stomp.StompHeaderAccessor;
import org.springframework.security.core.Authentication;
import org.springframework.util.Assert;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.messaging.StompSubProtocolHandler;

public class InterceptableStompSubProtocolHandler
extends StompSubProtocolHandler {
    private List<FromClientInterceptor> fromClientInterceptors = new ArrayList<FromClientInterceptor>();
    private List<ToClientInterceptor> toClientInterceptors = new ArrayList<ToClientInterceptor>();

    public void handleMessageFromClient(WebSocketSession session, WebSocketMessage<?> webSocketMessage, MessageChannel outputChannel) {
        MessageFromClient message;
        FromClientExecutionChain chain = new FromClientExecutionChain(this.fromClientInterceptors);
        Authentication authentication = (Authentication)session.getPrincipal();
        if (chain.applyPreHandle(session, authentication, message = this.getMessageFromClient(webSocketMessage), outputChannel, this)) {
            super.handleMessageFromClient(session, webSocketMessage, outputChannel);
            chain.applyPostHandle(session, authentication, message, outputChannel, this);
        }
    }

    public void handleMessageToClient(WebSocketSession session, Message<?> message) {
        Object payload;
        StompHeaderAccessor accessor;
        ToClientExecutionChain chain = new ToClientExecutionChain(this.toClientInterceptors);
        Authentication authentication = (Authentication)session.getPrincipal();
        if (chain.applyPreHandle(session, authentication, accessor = StompHeaderAccessor.wrap(message), payload = message.getPayload(), this)) {
            super.handleMessageToClient(session, message);
            chain.applyPostHandle(session, authentication, accessor, payload, this);
        }
    }

    public void addFromClientInterceptor(FromClientInterceptor interceptor) {
        Assert.notNull((Object)interceptor, (String)"interceptor\u4e0d\u80fd\u4e3anull");
        this.fromClientInterceptors.add(interceptor);
    }

    public void addToClientInterceptor(ToClientInterceptor interceptor) {
        Assert.notNull((Object)interceptor, (String)"interceptor\u4e0d\u80fd\u4e3anull");
        this.toClientInterceptors.add(interceptor);
    }

    private MessageFromClient getMessageFromClient(WebSocketMessage<?> webSocketMessage) {
        if (webSocketMessage instanceof TextMessage) {
            MessageFromClient message = new MessageFromClient();
            String payload = (String)((TextMessage)webSocketMessage).getPayload();
            String[] arr = payload.split("\n");
            LinkedTransferQueue<String> queue = new LinkedTransferQueue<String>();
            for (String str : arr) {
                String strTrim = str.trim();
                if (StringUtils.isEmpty((CharSequence)strTrim)) continue;
                queue.offer(strTrim);
            }
            String type = (String)queue.poll();
            message.setType(type);
            int last = 0;
            if ("SEND".equals(type)) {
                last = 1;
            }
            while (queue.size() > last) {
                String param = (String)queue.poll();
                if (param.startsWith("id:")) {
                    message.setSubId(param.split(":")[1].trim());
                    continue;
                }
                if (param.startsWith("destination:")) {
                    message.setDestination(param.split(":")[1].trim());
                    continue;
                }
                if (!param.startsWith("content-length:")) continue;
                message.setContentLength(Integer.valueOf(param.split(":")[1].trim()));
            }
            String content = (String)queue.poll();
            if (!StringUtils.isEmpty((CharSequence)content)) {
                if (content.startsWith("destination:") && StringUtils.isEmpty((CharSequence)message.getDestination())) {
                    message.setDestination(content.split(":")[1].trim());
                } else {
                    message.setContent(content.trim());
                }
            }
            return message;
        }
        return null;
    }
}

