package com.xzixi.websocket.interceptablewebsocket.config;

import com.xzixi.websocket.interceptablewebsocket.extension.InterceptableWebMvcStompEndpointRegistry;
import org.springframework.security.config.annotation.web.socket.AbstractSecurityWebSocketMessageBrokerConfigurer;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;

/**
 * 代替{@link AbstractSecurityWebSocketMessageBrokerConfigurer}
 * 重载{@link #registerStompEndpoints(StompEndpointRegistry)}
 * 将{@link StompEndpointRegistry}向下造型为{@link InterceptableWebMvcStompEndpointRegistry}
 * 子类直接重写{@link #registerStompEndpoints(InterceptableWebMvcStompEndpointRegistry)}即可，方便增加消息拦截器
 * 示例：
 * <pre>
 * &#064;Configuration
 * &#064;EnableInterceptableWebSocketMessageBroker
 * public class WebSocketSecurityConfig extends AbstractInterceptableSecurityWebSocketMessageBrokerConfigurer {
 * 	   &#064;Override
 * 	   protected void registerStompEndpoints(InterceptableWebMvcStompEndpointRegistry registry) {
 *         registry.addFromClientInterceptor(exampleFromClientInterceptor)
 *                 .addToClientInterceptor(exampleToClientInterceptor);
 * 	   }
 * }
 * </pre>
 */
public abstract class AbstractInterceptableSecurityWebSocketMessageBrokerConfigurer extends AbstractSecurityWebSocketMessageBrokerConfigurer {

    public void registerStompEndpoints(StompEndpointRegistry registry) {
        if (registry instanceof InterceptableWebMvcStompEndpointRegistry) {
            registerStompEndpoints((InterceptableWebMvcStompEndpointRegistry) registry);
        }
    }

    public void registerStompEndpoints(InterceptableWebMvcStompEndpointRegistry registry) {
    }

}
