/*
 * Decompiled with CFR 0.152.
 */
package com.xzixi.websocket.interceptablewebsocketdemo.websocket;

import com.xzixi.websocket.interceptablewebsocket.interceptor.ToClientInterceptor;
import com.xzixi.websocket.interceptablewebsocketdemo.entity.User;
import com.xzixi.websocket.interceptablewebsocketdemo.websocket.SessionIdRegistry;
import java.security.Principal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.messaging.simp.stomp.StompHeaderAccessor;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.messaging.StompSubProtocolHandler;

public class SessionIdRegistryInterceptor
implements ToClientInterceptor {
    @Autowired
    private SessionIdRegistry sessionIdRegistry;

    public void postHandle(WebSocketSession session, Principal principal, StompHeaderAccessor accessor, Object payload, StompSubProtocolHandler handler) {
        User user = (User)session.getAttributes().get("user");
        if (user == null) {
            return;
        }
        SimpMessageType type = accessor.getMessageType();
        if (SimpMessageType.CONNECT_ACK.equals((Object)type)) {
            String username = user.getUsername();
            String sessionId = session.getId();
            this.sessionIdRegistry.registerSessionId(username, sessionId);
        }
    }
}

