/*
 * Decompiled with CFR 0.152.
 */
package com.xzixi.websocket.interceptablewebsocketdemo.controller;

import com.xzixi.websocket.interceptablewebsocketdemo.entity.Resource;
import com.xzixi.websocket.interceptablewebsocketdemo.entity.User;
import com.xzixi.websocket.interceptablewebsocketdemo.service.ResourceService;
import com.xzixi.websocket.interceptablewebsocketdemo.util.GenericMessageBuilder;
import com.xzixi.websocket.interceptablewebsocketdemo.util.MessageHeadersBuilder;
import com.xzixi.websocket.interceptablewebsocketdemo.websocket.SessionIdRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.messaging.support.GenericMessage;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class MainController {
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private SessionIdRegistry sessionIdRegistry;
    @Autowired
    private SimpMessagingTemplate template;

    @GetMapping(value={"/", "login"})
    public String toLogin() {
        return "login";
    }

    @GetMapping(value={"index"})
    public String toIndex() {
        return "index";
    }

    @PostMapping(value={"login"})
    @ResponseBody
    public String login(User user, HttpSession session) {
        String username = user.getUsername();
        String password = user.getPassword();
        if ("admin".equals(username) && "admin".equals(password) || "guest".equals(username) && "guest".equals(password) || "user".equals(username) && "user".equals(password)) {
            List<Resource> resources = this.resourceService.findResourceByUsername(username);
            user.setResources(resources);
            session.setAttribute("user", (Object)user);
            return "ok";
        }
        return "error";
    }

    @PostMapping(value={"checkLogin"})
    @ResponseBody
    public String checkLogin(HttpSession session) {
        User user = (User)session.getAttribute("user");
        if (user == null) {
            return "error";
        }
        return "ok";
    }

    @PostMapping(value={"logout"})
    @ResponseBody
    public String logout(HttpSession session) {
        session.removeAttribute("user");
        return "ok";
    }

    @PostMapping(value={"broadcast"})
    @ResponseBody
    public String broadcast(String content, HttpSession session) {
        User user = (User)session.getAttribute("user");
        String username = user.getUsername();
        if (!"admin".equals(username)) {
            return "error";
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("username", username);
        map.put("content", content);
        GenericMessage<byte[]> message = new GenericMessageBuilder().payload(map).destination("/topic/broadcast").leaveMutable(true).build();
        this.template.send(message);
        return "ok";
    }

    @PostMapping(value={"chat"})
    @ResponseBody
    public String chat(String target, String content, HttpSession session) {
        User user = (User)session.getAttribute("user");
        String username = user.getUsername();
        if (!"admin".equals(username) && !"user".equals(username)) {
            return "error";
        }
        Set<String> sessionIds = this.sessionIdRegistry.getSessionIds(target);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("username", username);
        map.put("content", content);
        sessionIds.forEach(sessionId -> this.template.convertAndSendToUser(sessionId, "/topic/chat", (Object)map, (Map)new MessageHeadersBuilder().sessionId((String)sessionId).leaveMutable(true).build()));
        return "ok";
    }
}

