/*
 * Decompiled with CFR 0.152.
 */
package com.xzixi.websocket.interceptablewebsocketdemo.websocket;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;

public class SessionIdRegistry {
    private final Map<String, Set<String>> userSessionIds = new ConcurrentHashMap<String, Set<String>>();

    public Set<String> getSessionIds(String username) {
        Set<String> sessionIds = this.userSessionIds.get(username);
        return sessionIds != null ? sessionIds : Collections.emptySet();
    }

    public Map<String, Set<String>> getAllSessionIds() {
        return this.userSessionIds;
    }

    public void registerSessionId(String username, String sessionId) {
        Set<String> sessionIds = this.userSessionIds.get(username);
        if (sessionIds == null) {
            sessionIds = new CopyOnWriteArraySet<String>();
            this.userSessionIds.put(username, sessionIds);
        }
        sessionIds.add(sessionId);
    }

    public void unRegisterSessionId(String username, String sessionId) {
        Set<String> sessionIds = this.userSessionIds.get(username);
        if (sessionIds != null && sessionIds.remove(sessionId) && sessionIds.isEmpty()) {
            this.userSessionIds.remove(username);
        }
    }
}

