/*
 * Decompiled with CFR 0.152.
 */
package com.xzixi.websocket.interceptablewebsocketdemo.websocket;

import com.xzixi.websocket.interceptablewebsocket.interceptor.FromClientInterceptor;
import com.xzixi.websocket.interceptablewebsocket.util.MessageFromClient;
import com.xzixi.websocket.interceptablewebsocket.util.MessageMatcher;
import com.xzixi.websocket.interceptablewebsocket.util.NotifyUtil;
import com.xzixi.websocket.interceptablewebsocketdemo.entity.Resource;
import com.xzixi.websocket.interceptablewebsocketdemo.entity.User;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.MessageChannel;
import org.springframework.security.core.Authentication;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.messaging.StompSubProtocolHandler;

public class AccessDecisionFromClientInterceptor
implements FromClientInterceptor {
    @Autowired
    private MessageMatcher messageMatcher;
    @Autowired
    private NotifyUtil notifyUtil;

    public boolean preHandle(WebSocketSession session, Authentication authentication, MessageFromClient message, MessageChannel outputChannel, StompSubProtocolHandler handler) {
        String type = message.getType();
        if ("CONNECT".equals(type) || "CONNECT_ACK".equals(type) || "HEARTBEAT".equals(type) || "UNSUBSCRIBE".equals(type) || "DISCONNECT".equals(type) || "DISCONNECT_ACK".equals(type) || "OTHER".equals(type)) {
            return true;
        }
        User user = (User)session.getAttributes().get("user");
        if (user == null) {
            return false;
        }
        if (this.checkResources(message, user.getResources())) {
            return true;
        }
        this.notifyUtil.sendMessage(session, (Object)"\u6ca1\u6709\u6743\u9650");
        return false;
    }

    private boolean checkResources(MessageFromClient message, List<Resource> resources) {
        for (Resource resource : resources) {
            String protocol = resource.getProtocol();
            String pattern = resource.getPattern();
            String type = resource.getType();
            if (!"ws".equals(protocol) || !this.messageMatcher.matches(pattern, type, message)) continue;
            return true;
        }
        return false;
    }
}

