package com.xzixi.websocket.interceptablewebsocketdemo.config;

import com.xzixi.websocket.interceptablewebsocket.annotation.EnableInterceptableWebSocketMessageBroker;
import com.xzixi.websocket.interceptablewebsocket.config.AbstractInterceptableSecurityWebSocketMessageBrokerConfigurer;
import com.xzixi.websocket.interceptablewebsocket.extension.InterceptableWebMvcStompEndpointRegistry;
import com.xzixi.websocket.interceptablewebsocketdemo.websocket.AccessDecisionFromClientInterceptor;
import com.xzixi.websocket.interceptablewebsocketdemo.websocket.SessionIdRegistry;
import com.xzixi.websocket.interceptablewebsocketdemo.websocket.SessionIdRegistryInterceptor;
import com.xzixi.websocket.interceptablewebsocketdemo.websocket.SessionIdUnRegistryInterceptor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.security.config.annotation.web.messaging.MessageSecurityMetadataSourceRegistry;
import org.springframework.web.socket.messaging.StompSubProtocolErrorHandler;
import org.springframework.web.socket.server.support.HttpSessionHandshakeInterceptor;

@Configuration
@EnableInterceptableWebSocketMessageBroker
public class InterceptableSecurityWebSocketConfig extends AbstractInterceptableSecurityWebSocketMessageBrokerConfigurer {

    // 异常处理器
    @Bean
    public StompSubProtocolErrorHandler stompSubProtocolErrorHandler() {
        return new StompSubProtocolErrorHandler();
    }

    // 授权决策拦截器
    @Bean
    public AccessDecisionFromClientInterceptor accessDecisionFromClientInterceptor() {
        return new AccessDecisionFromClientInterceptor();
    }

    // sessionId记录
    @Bean
    public SessionIdRegistry sessionIdRegistry() {
        return new SessionIdRegistry();
    }

    // sessionId登记拦截器
    @Bean
    public SessionIdRegistryInterceptor sessionIdRegistryInterceptor() {
        return new SessionIdRegistryInterceptor();
    }

    // sessionId移除拦截器
    @Bean
    public SessionIdUnRegistryInterceptor sessionIdUnRegistryInterceptor() {
        return new SessionIdUnRegistryInterceptor();
    }

    @Override
    public void registerStompEndpoints(InterceptableWebMvcStompEndpointRegistry registry) {
        registry.addEndpoint("/endpoint")
                // 建立握手前将httpSession中的信息保存到webSocketSession，本案例将用户登录信息保存在httpSession
                .addInterceptors(new HttpSessionHandshakeInterceptor())
                // 如果需要跨域连接webSocket，将这一行注解打开，参数可以指定域名
                // .setAllowedOrigins("*")
                .withSockJS();
        registry.setErrorHandler(stompSubProtocolErrorHandler());
        // 注册拦截器
        registry.addFromClientInterceptor(accessDecisionFromClientInterceptor()) // 消息授权决策
                .addFromClientInterceptor(sessionIdUnRegistryInterceptor()) // sessionId记录
                .addToClientInterceptor(sessionIdRegistryInterceptor()); // sessionId移除
    }

    // 取消所有检查，统一在授权决策拦截器中处理
    @Override
    protected void configureInbound(MessageSecurityMetadataSourceRegistry messages) {
        messages.anyMessage().permitAll();
    }

    // 关闭同源策略
    @Override
    protected boolean sameOriginDisabled() {
        return true;
    }

    @Override
    public void configureMessageBroker(MessageBrokerRegistry registry) {
        registry.enableSimpleBroker("/topic");
        registry.setApplicationDestinationPrefixes("/app");
    }

}
