/*
 * Decompiled with CFR 0.152.
 */
package com.xzixi.zookeeper.client;

import com.xzixi.zookeeper.exception.CuratorClientException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.recipes.cache.TreeCache;
import org.apache.curator.framework.recipes.cache.TreeCacheListener;
import org.apache.curator.framework.recipes.locks.InterProcessLock;
import org.apache.curator.framework.recipes.locks.InterProcessMultiLock;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.apache.curator.framework.recipes.locks.InterProcessReadWriteLock;
import org.apache.curator.framework.recipes.locks.InterProcessSemaphoreMutex;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CuratorClient {
    private static final Logger log = LoggerFactory.getLogger(CuratorClient.class);
    private static final String DEFAULT_CHARSET = "utf8";
    private CuratorFramework client;
    private String charset = "utf8";

    public CuratorClient(CuratorFrameworkFactory.Builder builder) {
        if (builder == null) {
            throw new CuratorClientException("builder\u4e0d\u80fd\u4e3anull");
        }
        this.client = builder.build();
    }

    public CuratorClient(CuratorFrameworkFactory.Builder builder, String charset) {
        if (builder == null) {
            throw new CuratorClientException("builder\u4e0d\u80fd\u4e3anull");
        }
        this.client = builder.build();
        this.charset = charset;
    }

    public void init() {
        this.client.start();
        this.client.getConnectionStateListenable().addListener((client, state) -> {
            if (state == ConnectionState.LOST) {
                log.info("lost session with zookeeper");
            } else if (state == ConnectionState.CONNECTED) {
                log.info("connected with zookeeper");
            } else if (state == ConnectionState.RECONNECTED) {
                log.info("reconnected with zookeeper");
            }
        });
    }

    public void stop() {
        this.client.close();
    }

    public void createNode(CreateMode mode, String path, String nodeData) {
        try {
            ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(mode)).forPath(path, nodeData.getBytes(Charset.forName(this.charset)));
        }
        catch (Exception e) {
            throw new CuratorClientException("\u6ce8\u518c\u51fa\u9519", e);
        }
    }

    public void createNode(CreateMode mode, String path) {
        try {
            ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(mode)).forPath(path);
        }
        catch (Exception e) {
            throw new CuratorClientException("\u6ce8\u518c\u51fa\u9519", e);
        }
    }

    public void deleteNode(String path) {
        try {
            this.deleteNode(path, true);
        }
        catch (Exception e) {
            throw new CuratorClientException("\u5220\u9664\u8282\u70b9\u5931\u8d25", e);
        }
    }

    public void deleteNode(String path, Boolean deleteChildre) {
        try {
            if (deleteChildre.booleanValue()) {
                this.client.delete().guaranteed().deletingChildrenIfNeeded().forPath(path);
            } else {
                this.client.delete().guaranteed().forPath(path);
            }
        }
        catch (Exception e) {
            throw new CuratorClientException("\u5220\u9664\u8282\u70b9\u5931\u8d25", e);
        }
    }

    public void setNodeData(String path, String data) {
        try {
            this.client.setData().forPath(path, data.getBytes(Charset.forName(this.charset)));
        }
        catch (Exception ex) {
            throw new CuratorClientException("\u8bbe\u7f6e\u8282\u70b9\u6570\u636e\u5931\u8d25", ex);
        }
    }

    public String getNodeData(String path) {
        try {
            return new String((byte[])this.client.getData().forPath(path), Charset.forName(this.charset));
        }
        catch (Exception e) {
            throw new CuratorClientException("\u83b7\u53d6\u6307\u5b9a\u8282\u70b9\u7684\u6570\u636e\u5931\u8d25", e);
        }
    }

    public String synNodeData(String path) {
        this.client.sync();
        return this.getNodeData(path);
    }

    public boolean isExistNode(String path) {
        this.client.sync();
        try {
            return null != this.client.checkExists().forPath(path);
        }
        catch (Exception e) {
            return false;
        }
    }

    public List<String> getChildren(String path) {
        List childrenList;
        try {
            childrenList = (List)this.client.getChildren().forPath(path);
        }
        catch (Exception e) {
            throw new CuratorClientException("\u83b7\u53d6\u5b50\u8282\u70b9\u51fa\u9519", e);
        }
        return childrenList;
    }

    public InterProcessSemaphoreMutex getSemaphoreMutexLock(String path) {
        return new InterProcessSemaphoreMutex(this.client, path);
    }

    public InterProcessMutex getMutexLock(String path) {
        return new InterProcessMutex(this.client, path);
    }

    public InterProcessMultiLock getMultiMutexLock(List<String> paths) {
        return new InterProcessMultiLock(this.client, paths);
    }

    public InterProcessMultiLock getMultiLock(List<InterProcessLock> locks) {
        return new InterProcessMultiLock(locks);
    }

    public void acquire(InterProcessLock lock) {
        try {
            lock.acquire();
        }
        catch (Exception e) {
            throw new CuratorClientException("\u52a0\u9501\u5931\u8d25", e);
        }
    }

    public void acquire(InterProcessLock lock, long time, TimeUnit unit) {
        try {
            lock.acquire(time, unit);
        }
        catch (Exception e) {
            throw new CuratorClientException("\u52a0\u9501\u5931\u8d25", e);
        }
    }

    public void release(InterProcessLock lock) {
        try {
            lock.release();
        }
        catch (Exception e) {
            throw new CuratorClientException("\u91ca\u653e\u9501\u5931\u8d25", e);
        }
    }

    public boolean isAcquiredInThisProcess(InterProcessLock lock) {
        return lock.isAcquiredInThisProcess();
    }

    public InterProcessReadWriteLock getReadWriteLock(String path) {
        return new InterProcessReadWriteLock(this.client, path);
    }

    public TreeCache watch(String path, TreeCacheListener listener, Executor pool) {
        TreeCache cache = new TreeCache(this.client, path);
        cache.getListenable().addListener((Object)listener, pool);
        try {
            cache.start();
        }
        catch (Exception e) {
            throw new CuratorClientException("\u76d1\u542c\u8282\u70b9\u51fa\u9519", e);
        }
        return cache;
    }

    public TreeCache watch(String path, TreeCacheListener listener) {
        TreeCache cache = new TreeCache(this.client, path);
        cache.getListenable().addListener((Object)listener);
        try {
            cache.start();
        }
        catch (Exception e) {
            throw new CuratorClientException("\u76d1\u542c\u8282\u70b9\u51fa\u9519", e);
        }
        return cache;
    }

    public void unwatch(TreeCache cache, TreeCacheListener listener) {
        if (cache == null) {
            throw new CuratorClientException("TreeCache\u5b9e\u4f8b\u4e0d\u80fd\u4e3anull");
        }
        cache.getListenable().removeListener((Object)listener);
    }

    public CuratorFramework getClient() {
        return this.client;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setClient(CuratorFramework client) {
        this.client = client;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CuratorClient)) {
            return false;
        }
        CuratorClient other = (CuratorClient)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CuratorFramework this$client = this.getClient();
        CuratorFramework other$client = other.getClient();
        if (this$client == null ? other$client != null : !this$client.equals(other$client)) {
            return false;
        }
        String this$charset = this.getCharset();
        String other$charset = other.getCharset();
        return !(this$charset == null ? other$charset != null : !this$charset.equals(other$charset));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CuratorClient;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CuratorFramework $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        String $charset = this.getCharset();
        result = result * 59 + ($charset == null ? 43 : $charset.hashCode());
        return result;
    }

    public String toString() {
        return "CuratorClient(client=" + this.getClient() + ", charset=" + this.getCharset() + ")";
    }

    public CuratorClient() {
    }
}

