/*
 * Decompiled with CFR 0.152.
 */
package com.xpcagey.logback;

import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.spi.ContextAware;
import com.amazonaws.services.logs.AWSLogs;
import com.amazonaws.services.logs.model.CreateLogStreamRequest;
import com.amazonaws.services.logs.model.DataAlreadyAcceptedException;
import com.amazonaws.services.logs.model.DescribeLogStreamsRequest;
import com.amazonaws.services.logs.model.DescribeLogStreamsResult;
import com.amazonaws.services.logs.model.InputLogEvent;
import com.amazonaws.services.logs.model.InvalidParameterException;
import com.amazonaws.services.logs.model.InvalidSequenceTokenException;
import com.amazonaws.services.logs.model.LogStream;
import com.amazonaws.services.logs.model.PutLogEventsRequest;
import com.amazonaws.services.logs.model.PutLogEventsResult;
import com.amazonaws.services.logs.model.ResourceAlreadyExistsException;
import com.amazonaws.services.logs.model.ResourceNotFoundException;
import com.amazonaws.services.logs.model.ServiceUnavailableException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.IntPredicate;
import java.util.function.Supplier;
import java.util.function.ToLongFunction;

class CloudWatchWorker<T> {
    static final int MAX_RETRIES = 10;
    static final int MAX_BATCH_SIZE = 100;
    private final BlockingQueue<Optional<T>> queue = new LinkedBlockingQueue<Optional<T>>();
    private final AWSLogs logs;
    private final String groupName;
    private final String streamName;
    private final Encoder<T> encoder;
    private final ToLongFunction<T> timer;
    private final ContextAware parent;
    private IntPredicate retryHook = CloudWatchWorker::defaultRetryHook;
    private String sequenceToken;
    private Future<Void> future;

    CloudWatchWorker(Supplier<AWSLogs> builder, String groupName, String streamName, Encoder<T> encoder, ToLongFunction<T> timer, ContextAware parent) {
        if (groupName.isEmpty()) {
            throw new IllegalArgumentException("'groupName' must be set");
        }
        if (streamName.isEmpty()) {
            throw new IllegalArgumentException("'streamName' or 'streamNameResolver' must be set");
        }
        if (encoder == null) {
            throw new IllegalArgumentException("'encoder' must be set");
        }
        if (timer == null) {
            throw new IllegalArgumentException("'timer' must be set");
        }
        this.logs = builder.get();
        this.groupName = groupName;
        this.streamName = streamName;
        this.encoder = encoder;
        this.timer = timer;
        this.parent = parent;
    }

    synchronized void start(Runnable stopHook) {
        if (this.future != null) {
            throw new IllegalStateException("Attempt to start the same CloudWatchAppender.Worker twice");
        }
        this.setSequenceToken();
        byte[] header = this.encoder.headerBytes();
        if (header.length > 0) {
            this.send(Collections.singleton(this.construct(System.currentTimeMillis(), header)));
        }
        this.future = CompletableFuture.runAsync(this::run, this.parent.getContext().getScheduledExecutorService()).thenRun(stopHook);
    }

    void add(T event) {
        this.queue.add(Optional.of(event));
    }

    void requestStop() {
        this.queue.add(Optional.empty());
    }

    void join() throws InterruptedException, ExecutionException {
        Future<Void> future = this.future;
        if (future != null) {
            future.get();
        }
    }

    private void run() {
        Optional event;
        ArrayList<InputLogEvent> list = new ArrayList<InputLogEvent>();
        do {
            try {
                event = this.queue.take();
            }
            catch (InterruptedException e) {
                this.parent.addWarn("stopping due to thread interrupt");
                Thread.currentThread().interrupt();
                break;
            }
            list.clear();
            while (event != null) {
                if (event.isPresent()) {
                    list.add(this.construct(this.timer.applyAsLong(event.get()), this.encoder.encode(event.get())));
                    if (list.size() >= 100) break;
                    event = (Optional)this.queue.poll();
                    continue;
                }
                byte[] footer = this.encoder.footerBytes();
                if (footer.length <= 0) break;
                list.add(this.construct(System.currentTimeMillis(), footer));
                break;
            }
            if (list.isEmpty()) continue;
            list.sort(Comparator.comparingLong(InputLogEvent::getTimestamp));
            this.send(list);
        } while (event == null || event.isPresent());
    }

    private InputLogEvent construct(long timestamp, byte[] encoded) {
        return new InputLogEvent().withTimestamp(Long.valueOf(timestamp)).withMessage(new String(encoded, StandardCharsets.UTF_8));
    }

    private void send(Collection<InputLogEvent> events) {
        PutLogEventsRequest request = new PutLogEventsRequest().withLogEvents(events).withLogGroupName(this.groupName).withLogStreamName(this.streamName);
        Throwable ex = null;
        int failures = 0;
        while (this.retryHook.test(failures)) {
            ex = null;
            if (this.sequenceToken != null) {
                request.setSequenceToken(this.sequenceToken);
            }
            try {
                PutLogEventsResult result = this.logs.putLogEvents(request);
                this.sequenceToken = result.getNextSequenceToken();
                break;
            }
            catch (DataAlreadyAcceptedException e) {
                this.sequenceToken = e.getExpectedSequenceToken();
                break;
            }
            catch (InvalidSequenceTokenException e) {
                this.sequenceToken = e.getExpectedSequenceToken();
                ex = e;
            }
            catch (ServiceUnavailableException e) {
                ex = e;
            }
            ++failures;
        }
        if (ex != null) {
            throw new RuntimeException("Retries exceeded", ex);
        }
    }

    private void setSequenceToken() {
        while (true) {
            try {
                this.parent.addInfo("Attempting to retrieve sequence number for group [" + this.groupName + "], stream [" + this.streamName + "]");
                DescribeLogStreamsResult result = this.logs.describeLogStreams(new DescribeLogStreamsRequest().withLogGroupName(this.groupName).withLogStreamNamePrefix(this.streamName));
                for (LogStream stream : result.getLogStreams()) {
                    if (!this.streamName.equals(stream.getLogStreamName())) continue;
                    this.sequenceToken = stream.getUploadSequenceToken();
                    break;
                }
                if (this.sequenceToken != null) break;
                this.logs.createLogStream(new CreateLogStreamRequest().withLogStreamName(this.streamName).withLogGroupName(this.groupName));
                this.sequenceToken = null;
                this.parent.addInfo("Created stream [" + this.streamName + "]");
            }
            catch (InvalidParameterException e) {
                throw new IllegalArgumentException("Bad argument passed to Amazon CloudWatch", e);
            }
            catch (ResourceNotFoundException e) {
                throw new IllegalArgumentException("Log Group [" + this.groupName + "] not found");
            }
            catch (ResourceAlreadyExistsException resourceAlreadyExistsException) {
                continue;
            }
            break;
        }
    }

    void setRetryHook(IntPredicate hook) {
        this.retryHook = hook;
    }

    static boolean defaultRetryHook(int failures) {
        if (failures >= 10) {
            return false;
        }
        if (failures == 0) {
            return true;
        }
        try {
            Thread.sleep(0xC8 ^ failures);
            return true;
        }
        catch (InterruptedException e2) {
            Thread.currentThread().interrupt();
            return false;
        }
    }
}

