/*
 * Decompiled with CFR 0.152.
 */
package com.xpcagey.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.spi.ContextAware;
import com.amazonaws.services.logs.AWSLogs;
import com.amazonaws.services.logs.AWSLogsClient;
import com.amazonaws.services.logs.AWSLogsClientBuilder;
import com.xpcagey.logback.CloudWatchWorker;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;

public class CloudWatchClassicAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private static final AWSLogsClientBuilder builder = AWSLogsClient.builder();
    private static final Supplier<AWSLogs> fallbackSupplier = () -> ((AWSLogsClientBuilder)builder).build();
    private static final Supplier<String> fallbackSource = () -> "";
    private Encoder<ILoggingEvent> encoder;
    private Supplier<AWSLogs> supplier;
    private Supplier<String> source;
    private String groupName;
    private volatile CloudWatchWorker<ILoggingEvent> worker;

    Encoder<ILoggingEvent> getEncoder() {
        return this.encoder;
    }

    String getGroupName() {
        return this.groupName == null ? "" : this.groupName;
    }

    String getStreamName() {
        return this.getStreamNameSupplier().get();
    }

    Supplier<String> getStreamNameSupplier() {
        return this.source == null ? fallbackSource : this.source;
    }

    Supplier<AWSLogs> getAWSLogsSupplier() {
        return this.supplier == null ? fallbackSupplier : this.supplier;
    }

    public void setEncoder(Encoder<ILoggingEvent> encoder) {
        this.encoder = encoder;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public void setStreamName(String streamName) {
        this.source = () -> streamName;
    }

    public void setStreamNameSupplier(Supplier<String> source) {
        this.source = source;
    }

    public void setAWSLogsSupplier(Supplier<AWSLogs> supplier) {
        this.supplier = supplier;
    }

    public void start() {
        if (this.isStarted()) {
            return;
        }
        this.startWith(new CloudWatchWorker<ILoggingEvent>(this.getAWSLogsSupplier(), this.getGroupName(), this.getStreamName(), this.getEncoder(), this::getTimetstamp, (ContextAware)this), this::onStop);
        this.addInfo("Initialization successful");
    }

    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        try {
            this.worker.requestStop();
            this.worker.join();
            this.worker = null;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.addError("Thread interrupted while waiting for shutdown of CloudWatchAppender");
        }
        catch (ExecutionException e) {
            this.addError("CloudWatchAppender had a fatal error", e);
        }
    }

    protected void append(ILoggingEvent event) {
        event.prepareForDeferredProcessing();
        this.worker.add(event);
    }

    void startWith(CloudWatchWorker<ILoggingEvent> worker, Runnable stopHook) {
        this.worker = worker;
        worker.start(stopHook);
        super.start();
    }

    void onStop() {
        super.stop();
    }

    private long getTimetstamp(ILoggingEvent e) {
        return e.getTimeStamp();
    }
}

