/*
 * Decompiled with CFR 0.152.
 */
package com.xpcagey.config.lightbend;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import com.xpcagey.config.spi.ConfigSink;
import com.xpcagey.config.spi.ValueCommand;
import com.xpcagey.config.spi.ValueCommandIterable;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Consumer;

class ConfigSource
implements com.xpcagey.config.spi.ConfigSource {
    private final String path;
    private final Config config;

    ConfigSource(String path) {
        this.path = path;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        this.config = path.isEmpty() ? ConfigFactory.load() : ConfigFactory.load((String)path);
    }

    public String getPath() {
        return this.path;
    }

    public Iterator<ValueCommand> iterator() {
        return new ValueCommandIterable((com.xpcagey.config.spi.ConfigSource)this).iterator();
    }

    public void register(Consumer<ValueCommand> event) {
    }

    public void unregister(Consumer<ValueCommand> event) {
    }

    public void close() {
    }

    public void initialize(ConfigSink sink) {
        LinkedList<AbstractMap.SimpleEntry<String, Object>> entries = new LinkedList<AbstractMap.SimpleEntry<String, Object>>();
        entries.addAll(this.config.root().entrySet());
        block7: while (!entries.isEmpty()) {
            Map.Entry entry = (Map.Entry)entries.remove();
            String key = (String)entry.getKey();
            ConfigValue value = (ConfigValue)entry.getValue();
            switch (value.valueType()) {
                case BOOLEAN: {
                    sink.set(key, false, ((Boolean)value.unwrapped()).booleanValue());
                    break;
                }
                case STRING: {
                    sink.set(key, false, (String)value.unwrapped());
                    break;
                }
                case NUMBER: {
                    Number n = (Number)value.unwrapped();
                    if (n.doubleValue() % 1.0 == 0.0) {
                        sink.set(key, false, n.longValue());
                        break;
                    }
                    sink.set(key, false, n.doubleValue());
                    break;
                }
                case LIST: {
                    int index = 0;
                    for (ConfigValue cv : (ConfigList)value) {
                        entries.add(new AbstractMap.SimpleEntry<String, ConfigValue>(key + "[" + index + "]", cv));
                        ++index;
                    }
                    continue block7;
                }
                case OBJECT: {
                    for (Map.Entry e : ((ConfigObject)value).entrySet()) {
                        entries.add(new AbstractMap.SimpleEntry(key + "." + (String)e.getKey(), e.getValue()));
                    }
                    continue block7;
                }
                default: {
                    sink.forceDefault(key);
                }
            }
        }
    }
}

