/*
 * Decompiled with CFR 0.152.
 */
package com.xpcagey.config.element;

import com.xpcagey.config.api.Element;
import com.xpcagey.config.element.DefaultManagement;
import com.xpcagey.config.element.RawValueElement;
import com.xpcagey.config.element.SubtreeElement;
import java.time.Duration;
import java.time.Instant;

abstract class BaseElement<T>
implements RawValueElement {
    private final String key;
    private final boolean sensitive;
    final transient T value;

    BaseElement(String key, boolean sensitive, T value) {
        this.key = key;
        this.sensitive = sensitive;
        this.value = value;
    }

    public boolean isSensitive() {
        return this.sensitive;
    }

    public String getKey() {
        return this.key;
    }

    public boolean getAsBoolean() {
        return DefaultManagement.getBoolean(this.key);
    }

    public double getAsDouble() {
        return DefaultManagement.getDouble(this.key);
    }

    public Duration getAsDuration() {
        return DefaultManagement.getDuration(this.key);
    }

    public Instant getAsInstant() {
        return DefaultManagement.getInstant(this.key);
    }

    public long getAsLong() {
        return DefaultManagement.getLong(this.key);
    }

    public String getAsString() {
        return DefaultManagement.getString(this.key);
    }

    public int compareTo(Element other) {
        if (other instanceof SubtreeElement) {
            return other.compareTo((Object)this);
        }
        return this.key.compareTo(other.getKey());
    }

    @Override
    public boolean hasRawValue(Object value) {
        return value != null && value.equals(this.value);
    }

    public boolean hasEqualValue(Element other) {
        if (other instanceof RawValueElement) {
            return ((RawValueElement)other).hasRawValue(this.value);
        }
        return false;
    }
}

