/*
 * Decompiled with CFR 0.152.
 */
package com.xpcagey.config.core;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiPredicate;
import java.util.function.Consumer;

public class WeakConsumers<T>
implements BiPredicate<Executor, T> {
    private final HashMap<Entry<? super T>, Boolean> mapping = new HashMap();
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock rLock = this.rwLock.readLock();
    private final Lock wLock = this.rwLock.writeLock();
    private final boolean shouldExpire;
    private boolean expired = false;

    WeakConsumers(boolean shouldExpire) {
        this.shouldExpire = shouldExpire;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean test(Executor exec, T t) {
        HashSet<Entry<T>> items;
        boolean dirty = false;
        this.rLock.lock();
        try {
            if (this.expired) {
                boolean bl = false;
                return bl;
            }
            items = new HashSet<Entry<T>>(this.mapping.keySet());
        }
        finally {
            this.rLock.unlock();
        }
        for (Entry entry : items) {
            if (entry.apply(exec, t)) continue;
            dirty = true;
        }
        if (!dirty) {
            return true;
        }
        this.wLock.lock();
        try {
            boolean bl = !this.checkExpired();
            return bl;
        }
        finally {
            this.wLock.unlock();
        }
    }

    boolean add(Consumer<? super T> element) {
        this.wLock.lock();
        try {
            if (this.expired) {
                boolean bl = false;
                return bl;
            }
            this.mapping.put(new Entry<T>(element), true);
            boolean bl = true;
            return bl;
        }
        finally {
            this.wLock.unlock();
        }
    }

    boolean remove(Consumer<? super T> element) {
        this.wLock.lock();
        try {
            this.mapping.remove(new Entry<T>(element), true);
            boolean bl = this.checkExpired();
            return bl;
        }
        finally {
            this.wLock.unlock();
        }
    }

    private boolean checkExpired() {
        if (!this.expired) {
            this.mapping.entrySet().removeIf(e -> ((Entry)e.getKey()).get() == null);
            this.expired = this.shouldExpire && this.mapping.isEmpty();
        }
        return this.expired;
    }

    void clear() {
        this.mapping.entrySet().clear();
        if (this.shouldExpire) {
            this.expired = true;
        }
    }

    static class Entry<Q>
    extends WeakReference<Consumer<Q>> {
        private final int hash;

        Entry(Consumer<Q> c) {
            super(c);
            this.hash = c.hashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            Consumer value = (Consumer)this.get();
            if (o instanceof Entry) {
                Consumer other = (Consumer)((Entry)o).get();
                if (value == null) {
                    return other == null;
                }
                return value.equals(other);
            }
            return false;
        }

        boolean apply(Executor exec, Q value) {
            Consumer func = (Consumer)this.get();
            if (func == null) {
                return false;
            }
            exec.execute(() -> func.accept(value));
            return true;
        }
    }
}

