/*
 * Decompiled with CFR 0.152.
 */
package com.xpcagey.config.core;

import com.xpcagey.config.api.Config;
import com.xpcagey.config.api.Element;
import com.xpcagey.config.core.ConfigEventBindings;
import com.xpcagey.config.core.ImmutableSortedElementSet;
import com.xpcagey.config.core.ModularConfig;
import com.xpcagey.config.element.RawValueElement;
import com.xpcagey.config.element.SubtreeElement;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class Subtree
implements Config {
    private final ModularConfig root;
    private final String prefix;
    private final ConfigEventBindings<RawValueElement> bindings;

    Subtree(ModularConfig root, Executor exec, String prefix) {
        if (!prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        this.prefix = prefix;
        this.root = root;
        this.bindings = new ConfigEventBindings(exec);
        root.attach(this::onUpdated, this::onRootClosed);
    }

    public String getName() {
        return this.prefix + "@" + this.root.getName();
    }

    public Iterator<String> getSources() {
        return this.root.getSources();
    }

    public SortedMap<String, Element> getAll() {
        TreeMap<String, Element> out = new TreeMap<String, Element>();
        for (Map.Entry<String, ImmutableSortedElementSet> entry : this.root.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(this.prefix)) continue;
            key = key.substring(this.prefix.length());
            out.put(key, new SubtreeElement(key, entry.getValue().element()));
        }
        return out;
    }

    public Config subtree(String prefix) {
        return this.root.subtree(this.prefix + prefix);
    }

    public Element getOrNull(String key) {
        RawValueElement item = this.root.getOrNull(this.prefix + key);
        if (item != null) {
            return new SubtreeElement(key, item);
        }
        return null;
    }

    public void addListener(Consumer<Element> listener) {
        this.bindings.addListener(listener);
    }

    public void removeListener(Consumer<Element> listener) {
        this.bindings.removeListener(listener);
    }

    public void removeTrigger(String key, Consumer<Element> trigger) {
        this.bindings.removeTrigger(key, trigger);
    }

    public void addTrigger(String key, Consumer<Element> trigger) {
        this.bindings.addTrigger(key, trigger);
        Element e = this.getOrNull(key);
        if (e != null) {
            trigger.accept(e);
        }
    }

    public void close() {
        this.root.detach(this::onUpdated, this::onRootClosed);
        this.bindings.clear();
    }

    public Iterator<Element> iterator() {
        return this.getAll().values().iterator();
    }

    private void onUpdated(RawValueElement e) {
        String key = e.getKey();
        if (!key.startsWith(this.prefix)) {
            return;
        }
        this.bindings.notify(new SubtreeElement(key.substring(this.prefix.length()), e));
    }

    private void onRootClosed(Boolean b) {
        if (b.booleanValue()) {
            this.close();
        }
    }
}

