/*
 * Decompiled with CFR 0.152.
 */
package com.xpcagey.config.core;

import com.xpcagey.config.api.Config;
import com.xpcagey.config.api.Element;
import com.xpcagey.config.core.ConfigEventBindings;
import com.xpcagey.config.core.ConfigModule;
import com.xpcagey.config.core.ImmutableSortedElementSet;
import com.xpcagey.config.core.MergeOperator;
import com.xpcagey.config.core.OnInitialized;
import com.xpcagey.config.core.OnRemoved;
import com.xpcagey.config.core.OnUpdated;
import com.xpcagey.config.core.Subtree;
import com.xpcagey.config.element.DefaultManagement;
import com.xpcagey.config.element.RawValueElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class ModularConfig
implements Config {
    private final ConcurrentHashMap<String, ImmutableSortedElementSet> values = new ConcurrentHashMap();
    private final List<ConfigSettings> settings = new ArrayList<ConfigSettings>();
    private final String name;
    private final Executor exec;
    private final ConfigEventBindings<RawValueElement> bindings;
    private final MergeOperator onInitialized;
    private final MergeOperator onUpdated;
    private final MergeOperator onRemoved;

    ModularConfig(Executor exec, String name) {
        this.name = name;
        this.exec = exec;
        this.bindings = new ConfigEventBindings(exec);
        this.onInitialized = new OnInitialized(this.values, this.bindings);
        this.onUpdated = new OnUpdated(this.values, this.bindings);
        this.onRemoved = new OnRemoved(this.values, this.bindings);
    }

    public String getName() {
        return this.name;
    }

    public Iterator<String> getSources() {
        final Iterator<ConfigSettings> it = this.settings.iterator();
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public String next() {
                ConfigModule module = ((ConfigSettings)it.next()).module;
                return module.getProvider() + ":" + module.getPath();
            }
        };
    }

    public Config subtree(String prefix) {
        return new Subtree(this, this.exec, prefix);
    }

    public SortedMap<String, Element> getAll() {
        TreeMap<String, Element> out = new TreeMap<String, Element>();
        for (Map.Entry<String, ImmutableSortedElementSet> entry : this.entrySet()) {
            out.put(entry.getKey(), entry.getValue().element());
        }
        return out;
    }

    public boolean hasKey(String key) {
        return this.values.containsKey(key);
    }

    public RawValueElement getOrNull(String key) {
        ImmutableSortedElementSet set = this.values.get(key);
        return set == null ? DefaultManagement.getOrNull(key) : set.element();
    }

    public Iterator<Element> iterator() {
        return new ImmutableSortedElementSet.Iterator(this.values.values().iterator());
    }

    public void addListener(Consumer<Element> listener) {
        this.bindings.addListener(listener);
    }

    public void removeListener(Consumer<Element> listener) {
        this.bindings.addListener(listener);
    }

    public void removeTrigger(String key, Consumer<Element> trigger) {
        this.bindings.addTrigger(key, trigger);
    }

    public void addTrigger(String key, Consumer<Element> trigger) {
        this.bindings.addTrigger(key, trigger);
        RawValueElement e = this.getOrNull(key);
        if (e != null) {
            trigger.accept(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        List<ConfigSettings> list = this.settings;
        synchronized (list) {
            for (ConfigSettings s : this.settings) {
                s.module.removeListener(s.listener);
                s.module.removeReaper(s.reaper);
            }
            this.settings.clear();
        }
        this.bindings.notifyClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void append(ConfigModule module) {
        List<ConfigSettings> list = this.settings;
        synchronized (list) {
            int score = this.settings.size();
            ConfigSettings c = new ConfigSettings(module, element -> this.onUpdated.apply(element.getKey(), score, (RawValueElement)element), key -> this.onRemoved.apply((String)key, score, null));
            this.settings.add(c);
            module.addListener(c.listener);
            module.addReaper(c.reaper);
            for (RawValueElement e : module) {
                this.onInitialized.apply(e.getKey(), score, e);
            }
        }
    }

    void attach(Consumer<RawValueElement> listener, Consumer<Boolean> dependency) {
        this.bindings.addListener(listener);
        this.bindings.addDependency(dependency);
    }

    void detach(Consumer<RawValueElement> listener, Consumer<Boolean> dependency) {
        this.bindings.removeListener(listener);
        this.bindings.removeDependency(dependency);
    }

    Set<Map.Entry<String, ImmutableSortedElementSet>> entrySet() {
        return this.values.entrySet();
    }

    private static class ConfigSettings {
        final ConfigModule module;
        final Consumer<RawValueElement> listener;
        final Consumer<String> reaper;

        ConfigSettings(ConfigModule module, Consumer<RawValueElement> listener, Consumer<String> reaper) {
            this.module = module;
            this.listener = listener;
            this.reaper = reaper;
        }
    }
}

