/*
 * Decompiled with CFR 0.152.
 */
package com.xpcagey.config.core;

import com.xpcagey.config.api.Element;
import com.xpcagey.config.element.RawValueElement;
import java.util.Arrays;

class ImmutableSortedElementSet {
    private final Entry[] entries;

    ImmutableSortedElementSet(int score, RawValueElement e) {
        this.entries = new Entry[]{new Entry(score, e)};
    }

    private ImmutableSortedElementSet(Entry[] entries) {
        this.entries = entries;
    }

    RawValueElement element() {
        return this.entries[0].element;
    }

    boolean matches(ImmutableSortedElementSet o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        RawValueElement oe = o.element();
        RawValueElement e = this.element();
        return e.isSensitive() == oe.isSensitive() && e.getKey().equals(oe.getKey()) && e.hasEqualValue(oe);
    }

    ImmutableSortedElementSet addOrReplace(int score, RawValueElement e) {
        Entry entry = new Entry(score, e);
        int index = Arrays.binarySearch(this.entries, entry);
        if (index < 0) {
            return this.add(~index, entry);
        }
        Entry[] copy = new Entry[this.entries.length];
        System.arraycopy(this.entries, 0, copy, 0, this.entries.length);
        copy[index] = entry;
        return new ImmutableSortedElementSet(copy);
    }

    ImmutableSortedElementSet addOrIgnore(int score, RawValueElement e) {
        Entry entry = new Entry(score, e);
        int index = Arrays.binarySearch(this.entries, entry);
        if (index < 0) {
            return this.add(~index, entry);
        }
        return this;
    }

    ImmutableSortedElementSet remove(int score) {
        Entry entry = new Entry(score, null);
        int index = Arrays.binarySearch(this.entries, entry);
        if (index < 0) {
            return this;
        }
        if (this.entries.length == 1) {
            return null;
        }
        Entry[] copy = new Entry[this.entries.length - 1];
        System.arraycopy(this.entries, 0, copy, 0, index);
        System.arraycopy(this.entries, index + 1, copy, index, this.entries.length - (index + 1));
        return new ImmutableSortedElementSet(copy);
    }

    private ImmutableSortedElementSet add(int index, Entry entry) {
        Entry[] copy = new Entry[this.entries.length + 1];
        System.arraycopy(this.entries, 0, copy, 0, index);
        copy[index] = entry;
        if (index < this.entries.length) {
            System.arraycopy(this.entries, index, copy, index + 1, this.entries.length - index);
        }
        return new ImmutableSortedElementSet(copy);
    }

    static class Iterator
    implements java.util.Iterator<Element> {
        private final java.util.Iterator<ImmutableSortedElementSet> it;

        Iterator(java.util.Iterator<ImmutableSortedElementSet> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Element next() {
            ImmutableSortedElementSet set = this.it.next();
            return set.element();
        }
    }

    static class Entry
    implements Comparable<Entry> {
        private final int score;
        private final RawValueElement element;

        Entry(int score, RawValueElement element) {
            this.score = score;
            this.element = element;
        }

        @Override
        public int compareTo(Entry o) {
            return Integer.compare(this.score, o.score);
        }
    }
}

