/*
 * Decompiled with CFR 0.152.
 */
package com.xpcagey.config.core;

import com.xpcagey.config.api.Element;
import com.xpcagey.config.core.WeakConsumers;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

class ConfigEventBindings<T extends Element> {
    private final ConcurrentHashMap<String, WeakConsumers<T>> triggers = new ConcurrentHashMap();
    private final WeakConsumers<String> reapers = new WeakConsumers(false);
    private final WeakConsumers<Boolean> dependencies = new WeakConsumers(false);
    private final WeakConsumers<T> listeners = new WeakConsumers(false);
    private final Executor exec;

    ConfigEventBindings(Executor exec) {
        this.exec = exec;
    }

    void addReaper(Consumer<String> listener) {
        this.reapers.add(listener);
    }

    void removeReaper(Consumer<String> listener) {
        this.reapers.remove(listener);
    }

    void notifyRemoved(String key) {
        this.reapers.test(this.exec, key);
    }

    void addListener(Consumer<? super T> listener) {
        this.listeners.add(listener);
    }

    void removeListener(Consumer<? super T> listener) {
        this.listeners.remove(listener);
    }

    void addTrigger(String key, Consumer<? super T> trigger) {
        WeakConsumers values;
        while (!(values = this.triggers.computeIfAbsent(key, k -> new WeakConsumers(true))).add(trigger)) {
            this.triggers.remove(key, values);
        }
    }

    void removeTrigger(String key, Consumer<? super T> trigger) {
        WeakConsumers values = this.triggers.getOrDefault(key, null);
        if (values != null && values.remove(trigger)) {
            this.triggers.remove(key, values);
        }
    }

    void notify(T e) {
        this.listeners.test(this.exec, e);
        WeakConsumers values = this.triggers.getOrDefault(e.getKey(), null);
        if (values != null && !values.test(this.exec, e)) {
            this.triggers.remove(e.getKey(), values);
        }
    }

    void addDependency(Consumer<Boolean> dependency) {
        this.dependencies.add(dependency);
    }

    void removeDependency(Consumer<Boolean> dependency) {
        this.dependencies.remove(dependency);
    }

    void notifyClosed() {
        this.dependencies.test(this.exec, true);
    }

    void clear() {
        this.reapers.clear();
        this.listeners.clear();
        this.dependencies.clear();
        this.triggers.forEach((k, t) -> t.clear());
    }
}

