/*
 * Decompiled with CFR 0.152.
 */
package com.xpcagey.config.element;

import com.xpcagey.config.api.Element;
import com.xpcagey.config.element.RawValueElement;
import java.time.Duration;
import java.time.Instant;
import java.time.format.DateTimeParseException;

public class DefaultElement
implements RawValueElement {
    private final Object rawValue;
    private final boolean booleanValue;
    private final String stringValue;
    private final double doubleValue;
    private final Duration durationValue;
    private final Instant instantValue;
    private final long longValue;
    private final String key;

    public DefaultElement(String key, boolean value) {
        this.key = key;
        this.rawValue = value;
        this.booleanValue = value;
        this.stringValue = Boolean.valueOf(value).toString();
        this.doubleValue = value ? 1.0 : 0.0;
        this.durationValue = Duration.ZERO;
        this.instantValue = Instant.EPOCH;
        this.longValue = value ? 1L : 0L;
    }

    public DefaultElement(String key, double value) {
        Double dbl = value;
        this.key = key;
        this.rawValue = value;
        this.booleanValue = value != 0.0;
        this.stringValue = dbl.toString();
        this.doubleValue = value;
        this.durationValue = Duration.ofMillis(dbl.longValue());
        this.instantValue = Instant.ofEpochMilli(dbl.longValue());
        this.longValue = dbl.longValue();
    }

    public DefaultElement(String key, Duration value) {
        this.key = key;
        this.rawValue = value;
        this.booleanValue = false;
        this.stringValue = value.toString();
        this.doubleValue = value.toMillis();
        this.durationValue = value;
        this.instantValue = Instant.EPOCH;
        this.longValue = value.toMillis();
    }

    public DefaultElement(String key, Instant value) {
        this.key = key;
        this.rawValue = value;
        this.booleanValue = false;
        this.stringValue = value.toString();
        this.doubleValue = value.toEpochMilli();
        this.durationValue = Duration.ZERO;
        this.instantValue = value;
        this.longValue = value.toEpochMilli();
    }

    public DefaultElement(String key, long value) {
        Long lng = value;
        this.key = key;
        this.rawValue = value;
        this.booleanValue = value != 0L;
        this.stringValue = lng.toString();
        this.doubleValue = value;
        this.durationValue = Duration.ofMillis(value);
        this.instantValue = Instant.ofEpochMilli(value);
        this.longValue = value;
    }

    public DefaultElement(String key, String value) {
        this.key = key;
        this.rawValue = value;
        this.booleanValue = Boolean.valueOf(value);
        this.stringValue = value;
        double dValue = 0.0;
        try {
            dValue = Double.valueOf(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.doubleValue = dValue;
        Duration duValue = Duration.ZERO;
        try {
            duValue = Duration.parse(value);
        }
        catch (DateTimeParseException dateTimeParseException) {
            // empty catch block
        }
        this.durationValue = duValue;
        Instant iValue = Instant.EPOCH;
        try {
            iValue = Instant.parse(value);
        }
        catch (DateTimeParseException dateTimeParseException) {
            // empty catch block
        }
        this.instantValue = iValue;
        long lValue = 0L;
        try {
            lValue = Double.valueOf(value).longValue();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.longValue = lValue;
    }

    public boolean isSensitive() {
        return false;
    }

    public String getKey() {
        return this.key;
    }

    public boolean getAsBoolean() {
        return this.booleanValue;
    }

    public double getAsDouble() {
        return this.doubleValue;
    }

    public Duration getAsDuration() {
        return this.durationValue;
    }

    public Instant getAsInstant() {
        return this.instantValue;
    }

    public long getAsLong() {
        return this.longValue;
    }

    public String getAsString() {
        return this.stringValue;
    }

    public int compareTo(Element o) {
        return this.key.compareTo(o.getKey());
    }

    @Override
    public boolean hasRawValue(Object value) {
        return value != null && value.equals(this.rawValue);
    }

    public boolean hasEqualValue(Element other) {
        if (other instanceof RawValueElement) {
            return ((RawValueElement)other).hasRawValue(this.rawValue);
        }
        return false;
    }
}

