/*
 * Decompiled with CFR 0.152.
 */
package com.xpcagey.config.core;

import com.xpcagey.config.api.Descriptor;
import com.xpcagey.config.core.ConfigEventBindings;
import com.xpcagey.config.element.BooleanElement;
import com.xpcagey.config.element.DoubleElement;
import com.xpcagey.config.element.DurationElement;
import com.xpcagey.config.element.InstantElement;
import com.xpcagey.config.element.LongElement;
import com.xpcagey.config.element.RawValueElement;
import com.xpcagey.config.element.ResetToDefaultElement;
import com.xpcagey.config.element.StringElement;
import com.xpcagey.config.spi.ConfigSink;
import com.xpcagey.config.spi.ConfigSource;
import com.xpcagey.config.spi.ValueCommand;
import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

class ConfigModule
implements Iterable<RawValueElement>,
AutoCloseable {
    private final NavigableMap<String, RawValueElement> values = new ConcurrentSkipListMap<String, RawValueElement>();
    private final ConfigEventBindings<RawValueElement> bindings;
    private final Consumer<ValueCommand> sink;
    private final ConfigSource source;
    private final Descriptor desc;

    ConfigModule(Executor exec, Descriptor desc, ConfigSource source) {
        this.bindings = new ConfigEventBindings(exec);
        this.desc = desc;
        this.source = source;
        this.sink = new Sink();
        this.source.register(this.sink);
    }

    RawValueElement getOrNull(String key) {
        return (RawValueElement)this.values.get(key);
    }

    void addListener(Consumer<RawValueElement> listener) {
        this.bindings.addListener(listener);
    }

    void removeListener(Consumer<RawValueElement> listener) {
        this.bindings.removeListener(listener);
    }

    void addTrigger(String key, Consumer<RawValueElement> trigger) {
        this.bindings.addTrigger(key, trigger);
    }

    void removeTrigger(String key, Consumer<RawValueElement> trigger) {
        this.bindings.removeTrigger(key, trigger);
    }

    @Override
    public Iterator<RawValueElement> iterator() {
        return this.values.values().iterator();
    }

    @Override
    public void close() {
        this.source.unregister(this.sink);
    }

    String getProvider() {
        return this.desc.getProvider();
    }

    String getAlias() {
        return this.desc.getAlias();
    }

    String getRawPath() {
        return this.desc.getRawPath();
    }

    String getPath() {
        return this.source.getPath();
    }

    void addReaper(Consumer<String> reaper) {
        this.bindings.addReaper(reaper);
    }

    void removeReaper(Consumer<String> reaper) {
        this.bindings.removeReaper(reaper);
    }

    private void update(RawValueElement e) {
        this.values.put(e.getKey(), e);
        this.bindings.notify(e);
    }

    class Sink
    implements ConfigSink,
    Consumer<ValueCommand> {
        Sink() {
        }

        @Override
        public void accept(ValueCommand command) {
            command.apply((ConfigSink)this);
        }

        public void set(String key, boolean isSensitive, boolean value) {
            ConfigModule.this.update(new BooleanElement(key, isSensitive, value));
        }

        public void set(String key, boolean isSensitive, double value) {
            ConfigModule.this.update(new DoubleElement(key, isSensitive, value));
        }

        public void set(String key, boolean isSensitive, Duration value) {
            ConfigModule.this.update(new DurationElement(key, isSensitive, value));
        }

        public void set(String key, boolean isSensitive, Instant value) {
            ConfigModule.this.update(new InstantElement(key, isSensitive, value));
        }

        public void set(String key, boolean isSensitive, long value) {
            ConfigModule.this.update(new LongElement(key, isSensitive, value));
        }

        public void set(String key, boolean isSensitive, String value) {
            ConfigModule.this.update(new StringElement(key, isSensitive, value));
        }

        public void forceDefault(String key) {
            ConfigModule.this.update(new ResetToDefaultElement(key));
        }

        public void clear(String key) {
            ConfigModule.this.values.remove(key);
            ConfigModule.this.bindings.notifyRemoved(key);
        }
    }
}

