/*
 * Decompiled with CFR 0.152.
 */
package com.xpcagey.config.core;

import com.xpcagey.config.api.CircularRequirementsException;
import com.xpcagey.config.api.Config;
import com.xpcagey.config.api.ConfigLoadException;
import com.xpcagey.config.api.Descriptor;
import com.xpcagey.config.api.MissingConfigException;
import com.xpcagey.config.api.MissingLoaderException;
import com.xpcagey.config.core.ConfigModule;
import com.xpcagey.config.core.ModularConfig;
import com.xpcagey.config.element.DefaultManagement;
import com.xpcagey.config.spi.ConfigServiceProvider;
import com.xpcagey.config.spi.ConfigSource;
import com.xpcagey.config.spi.IllegalPathException;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.Executor;

public class ConfigEngine
implements com.xpcagey.config.api.ConfigEngine {
    private final ServiceLoader<ConfigServiceProvider> loader = ServiceLoader.load(ConfigServiceProvider.class);
    private final Map<Descriptor, ConfigModule> modules = new HashMap<Descriptor, ConfigModule>();
    private final Map<String, ConfigServiceProvider> providers = new HashMap<String, ConfigServiceProvider>();

    public void setDefault(String key, boolean value) {
        DefaultManagement.set(key, value);
    }

    public void setDefault(String key, double value) {
        DefaultManagement.set(key, value);
    }

    public void setDefault(String key, Duration value) {
        DefaultManagement.set(key, value);
    }

    public void setDefault(String key, Instant value) {
        DefaultManagement.set(key, value);
    }

    public void setDefault(String key, long value) {
        DefaultManagement.set(key, value);
    }

    public void setDefault(String key, String value) {
        DefaultManagement.set(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Config load(String name, Executor exec, Descriptor ... descriptors) throws ConfigLoadException {
        Map<String, ConfigServiceProvider> map = this.providers;
        synchronized (map) {
            if (this.providers.isEmpty()) {
                for (ConfigServiceProvider csp : this.loader) {
                    this.providers.put(csp.getName(), csp);
                }
            }
            HashSet<String> resolvedAndMissing = new HashSet<String>();
            HashMap<String, ConfigModule> byAlias = new HashMap<String, ConfigModule>();
            while (resolvedAndMissing.size() < descriptors.length) {
                boolean progress = false;
                for (Descriptor d : descriptors) {
                    String alias = d.getAlias();
                    if (resolvedAndMissing.contains(alias) || !resolvedAndMissing.containsAll(d.getResolverInputs())) continue;
                    progress = true;
                    Descriptor resolved = this.resolve(exec, d, byAlias);
                    Optional<ConfigModule> module = Optional.ofNullable(this.modules.get(resolved));
                    if (!module.isPresent()) {
                        module = this.load(d).map(src -> {
                            ConfigModule found = new ConfigModule(exec, d, (ConfigSource)src);
                            this.modules.put(d, found);
                            return found;
                        });
                    }
                    resolvedAndMissing.add(alias);
                    module.ifPresent(m -> byAlias.put(alias, (ConfigModule)m));
                }
                if (progress) continue;
                throw new CircularRequirementsException(this.reportDeadlock(resolvedAndMissing, byAlias, Arrays.asList(descriptors)));
            }
            ModularConfig cfg = new ModularConfig(exec, name);
            for (Descriptor d : descriptors) {
                ConfigModule m2 = (ConfigModule)byAlias.get(d.getAlias());
                if (m2 == null) continue;
                cfg.append(m2);
            }
            return cfg;
        }
    }

    private Descriptor resolve(Executor exec, Descriptor d, Map<String, ConfigModule> byAlias) throws ConfigLoadException {
        try (ModularConfig cfg = new ModularConfig(exec, "");){
            for (String input : d.getResolverInputs()) {
                ConfigModule module = byAlias.get(input);
                if (module == null) continue;
                cfg.append(module);
            }
            Descriptor descriptor = d.resolve((Config)cfg);
            return descriptor;
        }
    }

    private Optional<ConfigSource> load(Descriptor d) throws ConfigLoadException {
        try {
            ConfigServiceProvider csp = this.providers.get(d.getProvider());
            if (csp != null) {
                return Optional.of(csp.load(d.getRawPath()));
            }
            if (d.isRequired()) {
                throw new MissingLoaderException(d.getProvider());
            }
            return Optional.empty();
        }
        catch (IllegalPathException e) {
            throw new com.xpcagey.config.api.IllegalPathException(e.loader, e.path, d.getRawPath(), (Throwable)e);
        }
    }

    private Collection<Descriptor> reportDeadlock(Set<String> resolvedAndMissing, Map<String, ConfigModule> byAlias, Collection<Descriptor> descriptors) throws ConfigLoadException {
        HashSet<String> included = new HashSet<String>(resolvedAndMissing);
        for (Descriptor d2 : descriptors) {
            included.add(d2.getAlias());
        }
        for (Descriptor d2 : descriptors) {
            if (included.containsAll(d2.getResolverInputs())) continue;
            throw new MissingConfigException(d2);
        }
        HashSet<Descriptor> circular = new HashSet<Descriptor>(descriptors);
        circular.removeIf(d -> byAlias.containsKey(d.getAlias()));
        return circular;
    }
}

