/*
 * Decompiled with CFR 0.152.
 */
package com.xpcagey.config.api;

import com.xpcagey.config.api.Config;
import com.xpcagey.config.api.Descriptor;
import com.xpcagey.config.api.MissingElementException;
import com.xpcagey.config.api.MissingResolverFieldException;
import com.xpcagey.config.api.PathDescriptor;
import java.util.Arrays;
import java.util.Collection;

public class KeyedDescriptor
extends Descriptor {
    private static final String DELIMITER = "::";
    private final String key;
    private final String[] sources;

    public KeyedDescriptor(String provider, String key, String alias, boolean required, String ... sources) {
        super(provider, alias, required);
        this.sources = sources;
        this.key = key;
    }

    @Override
    public String getRawPath() {
        return this.key + "@" + String.join((CharSequence)DELIMITER, this.sources);
    }

    @Override
    public Collection<String> getResolverInputs() {
        return Arrays.asList(this.sources);
    }

    @Override
    public Descriptor resolve(Config config) throws MissingResolverFieldException {
        String provider = this.getProvider();
        try {
            String path = config.getOrThrow(this.key).getAsString();
            return new PathDescriptor(provider, path, this.getAlias(), this.isRequired());
        }
        catch (MissingElementException e) {
            throw new MissingResolverFieldException(e);
        }
    }
}

