/*
 * Decompiled with CFR 0.152.
 */
package com.xpcagey.config.api;

import com.xpcagey.config.api.Config;
import com.xpcagey.config.api.ConfigEngine;
import com.xpcagey.config.api.ConfigLoadException;
import com.xpcagey.config.api.Descriptor;
import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.Executor;

public final class ConfigSystem {
    private static Iterable<ConfigEngine> loader = ServiceLoader.load(ConfigEngine.class);
    private static final Object lock = new Object();
    private static volatile ConfigEngine engine;

    private ConfigSystem() {
    }

    public static void setDefault(String key, boolean value) {
        ConfigSystem.bind().setDefault(key, value);
    }

    public static void setDefault(String key, double value) {
        ConfigSystem.bind().setDefault(key, value);
    }

    public static void setDefault(String key, Duration value) {
        ConfigSystem.bind().setDefault(key, value);
    }

    public static void setDefault(String key, Instant value) {
        ConfigSystem.bind().setDefault(key, value);
    }

    public static void setDefault(String key, long value) {
        ConfigSystem.bind().setDefault(key, value);
    }

    public static void setDefault(String key, String value) {
        ConfigSystem.bind().setDefault(key, value);
    }

    public static synchronized Config load(String name, Executor exec, Descriptor ... descriptors) throws ConfigLoadException {
        return ConfigSystem.bind().load(name, loader.getClass().getClassLoader(), exec, descriptors);
    }

    public static synchronized Config load(String name, ClassLoader classLoader, Executor exec, Descriptor ... descriptors) throws ConfigLoadException {
        return ConfigSystem.bind().load(name, classLoader, exec, descriptors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConfigEngine bind() {
        ConfigEngine local = engine;
        if (local == null) {
            Object object = lock;
            synchronized (object) {
                local = engine;
                if (local == null) {
                    engine = local = ConfigSystem.load();
                }
            }
        }
        return local;
    }

    private static ConfigEngine load() {
        Iterator<ConfigEngine> engines = loader.iterator();
        if (!engines.hasNext()) {
            throw new IllegalStateException("No ConfigEngine has been found on the ClassPath");
        }
        ConfigEngine found = engines.next();
        if (engines.hasNext()) {
            throw new IllegalStateException("Multiple ConfigEngines have been found on the ClassPath");
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reset(Iterable<ConfigEngine> testLoader) {
        Object object = lock;
        synchronized (object) {
            loader = testLoader != null ? testLoader : ServiceLoader.load(ConfigEngine.class);
            engine = null;
        }
    }
}

