/*
 * Decompiled with CFR 0.152.
 */
package com.xpcagey.config.api;

import com.xpcagey.config.api.Element;
import com.xpcagey.config.api.MissingElementException;
import java.util.Iterator;
import java.util.Optional;
import java.util.SortedMap;
import java.util.function.Consumer;

public interface Config
extends Iterable<Element>,
AutoCloseable {
    public String getName();

    public Iterator<String> getSources();

    public Config subtree(String var1);

    default public boolean hasKey(String key) {
        return this.getOrNull(key) != null;
    }

    public SortedMap<String, Element> getAll();

    default public Optional<Element> get(String key) {
        return Optional.ofNullable(this.getOrNull(key));
    }

    public Element getOrNull(String var1);

    default public Element getOrThrow(String key) throws MissingElementException {
        Element e = this.getOrNull(key);
        if (e == null) {
            throw new MissingElementException(this.getName(), key);
        }
        return e;
    }

    public void addListener(Consumer<Element> var1);

    public void removeListener(Consumer<Element> var1);

    public void addTrigger(String var1, Consumer<Element> var2);

    public void removeTrigger(String var1, Consumer<Element> var2);
}

