/*
 * Decompiled with CFR 0.152.
 */
package com.xpcagey.config.api;

import com.xpcagey.config.api.Config;
import com.xpcagey.config.api.ConfigLoadException;
import java.util.Collection;

public abstract class Descriptor
implements Comparable<Descriptor> {
    private final String provider;
    private final String alias;
    private final boolean required;

    protected Descriptor(String provider, String alias, boolean required) {
        this.provider = provider;
        this.alias = alias;
        this.required = required;
    }

    public String getProvider() {
        return this.provider;
    }

    public String getAlias() {
        return this.alias;
    }

    public boolean isRequired() {
        return this.required;
    }

    public abstract String getRawPath();

    public abstract Collection<String> getResolverInputs();

    public abstract Descriptor resolve(Config var1) throws ConfigLoadException;

    @Override
    public int compareTo(Descriptor o) {
        int comp = this.getAlias().compareTo(o.getAlias());
        if (comp != 0) {
            return comp;
        }
        comp = this.getProvider().compareTo(o.getProvider());
        if (comp != 0) {
            return comp;
        }
        return this.getRawPath().compareTo(o.getRawPath());
    }

    public boolean equals(Object o) {
        if (o instanceof Descriptor) {
            return this.equals((Descriptor)o);
        }
        return super.equals(o);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.alias + "=" + this.provider + "://" + this.getRawPath();
    }

    private boolean equals(Descriptor o) {
        return this.provider.equals(o.provider) && this.alias.equals(o.alias) && this.getRawPath().equals(o.getRawPath());
    }
}

