/*
 * Decompiled with CFR 0.152.
 */
package com.xpcagey.config.api;

import com.xpcagey.config.api.ConfigLoadException;
import com.xpcagey.config.api.Descriptor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class CircularRequirementsException
extends ConfigLoadException {
    public final Set<Descriptor> desc;

    public CircularRequirementsException(Collection<Descriptor> desc) {
        super(CircularRequirementsException.buildMessage(desc));
        this.desc = new HashSet<Descriptor>(desc);
    }

    private static String buildMessage(Collection<Descriptor> desc) {
        StringBuilder builder = new StringBuilder();
        for (Descriptor d : desc) {
            if (builder.length() == 0) {
                builder.append("Found circular references while attempting to load [");
            } else {
                builder.append("], [");
            }
            builder.append(d.toString());
        }
        builder.append("]");
        return builder.toString();
    }
}

