/*
 * Decompiled with CFR 0.152.
 */
package com.v1ok.uuid.snowflake;

import com.v1ok.uuid.IDGenerate;
import com.v1ok.uuid.property.UUIDType;
import com.v1ok.uuid.snowflake.support.IDParseDate;
import com.v1ok.uuid.util.NumericConvertUtil;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateImpl
implements IDGenerate {
    private static final Logger log = LoggerFactory.getLogger(GenerateImpl.class);
    private static final Lock writeLock = new ReentrantLock();
    public static final long TIME_WHEN_EPOCH = 1555664758384L;
    public static final int TO_STRING_BASE = 16;
    private static final long SEQUENCE_BITS = 12L;
    private static final long WORKER_ID_BITS = 5L;
    private static final long DATA_CENTER_ID_BITS = 5L;
    private static final long MAX_DATA_CENTER_ID_NUM = 31L;
    private static final long MAX_WORKER_ID_NUM = 31L;
    private static final long MAX_SEQUENCE_NUM = 4095L;
    public static final long WORKER_ID_LEFT_SHIFT = 12L;
    public static final long DATA_CENTER_ID_LEFT_SHIFT = 17L;
    public static final long TIMESTAMP_LEFT_SHIFT = 22L;
    private long workerId;
    private long dataCenterId;
    private long epoch;
    private static AtomicLong lastTimestamp = new AtomicLong(-1L);
    private static AtomicLong sequence = new AtomicLong(0L);
    private int base;
    private UUIDType uuidType;
    static final int THREAD_COUNT = 6;
    static GenerateImpl idGenerate = new GenerateImpl(1L, 1L);
    static CountDownLatch countDownLatch = new CountDownLatch(6);
    static Set<Long> TEXT_IDS = Collections.synchronizedSet(new HashSet());

    public GenerateImpl(long workerId, long dataCenterId) {
        this(workerId, dataCenterId, 1555664758384L, 16);
    }

    public GenerateImpl(long workerId, long dataCenterId, long epoch, int base) {
        this.epoch = epoch;
        this.workerId = workerId;
        this.dataCenterId = dataCenterId;
        this.base = base;
        if (workerId > 31L || workerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", 31L));
        }
        if (dataCenterId > 31L || dataCenterId < 0L) {
            throw new IllegalArgumentException(String.format("data center Id can't be greater than %d or less than 0", 31L));
        }
    }

    @Override
    public Object nextId() {
        if (this.uuidType == UUIDType.TO_STRING) {
            return this.nextIdToString();
        }
        return this.nextIdToLong();
    }

    @Override
    public String nextIdToString() {
        return NumericConvertUtil.toOtherBaseString(this.nextIdToLong(), this.base);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long nextIdToLong() {
        writeLock.lock();
        try {
            long timestamp = this.timeGen();
            long lastTimestampValue = lastTimestamp.get();
            if (timestamp < lastTimestampValue) {
                log.warn(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", lastTimestampValue - timestamp));
                timestamp = this.tilNextMillis(lastTimestampValue);
            }
            if (lastTimestampValue == timestamp) {
                long sequenceValue = sequence.incrementAndGet() & 0xFFFL;
                if (sequenceValue == 0L) {
                    timestamp = this.tilNextMillis(lastTimestampValue);
                }
                lastTimestamp.set(timestamp);
                Long l = timestamp - this.epoch << 22 | this.dataCenterId << 17 | this.workerId << 12 | sequenceValue;
                return l;
            }
            sequence.set(0L);
            lastTimestamp.set(timestamp);
            Long l = timestamp - this.epoch << 22 | this.dataCenterId << 17 | this.workerId << 12 | sequence.get();
            return l;
        }
        finally {
            writeLock.unlock();
        }
    }

    public long getEpoch() {
        return this.epoch;
    }

    public void setEpoch(long epoch) {
        this.epoch = epoch;
    }

    public long getWorkerId() {
        return this.workerId;
    }

    public void setWorkerId(long workerId) {
        this.workerId = workerId;
    }

    public long getDataCenterId() {
        return this.dataCenterId;
    }

    public void setDataCenterId(long dataCenterId) {
        this.dataCenterId = dataCenterId;
    }

    public int getBase() {
        return this.base;
    }

    public void setBase(int base) {
        this.base = base;
    }

    public UUIDType getUuidType() {
        return this.uuidType;
    }

    public void setUuidType(UUIDType uuidType) {
        this.uuidType = uuidType;
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            long sleepTime = lastTimestamp - timestamp;
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                log.error("Thread sleep is error", (Throwable)e);
            }
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    private long timeGen() {
        return System.currentTimeMillis();
    }

    public static void main(String[] args) throws InterruptedException {
        System.out.println(System.currentTimeMillis());
        Long x = idGenerate.nextIdToLong();
        Date parse = new IDParseDate(idGenerate).parse(x);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String startTime = sdf.format(parse);
        System.out.println(startTime);
        System.out.println(x);
        System.out.println(idGenerate.nextIdToString());
        System.out.println(x.toString().length());
        for (int i = 0; i < 6; ++i) {
            Thread thread = new Thread(() -> {
                for (int j = 0; j < 1000; ++j) {
                    Long id = idGenerate.nextIdToLong();
                    if (TEXT_IDS.contains(id)) {
                        String threadName = Thread.currentThread().getName();
                        System.out.println(String.format("has same id %d [%s]", id, threadName));
                    }
                    TEXT_IDS.add(id);
                }
                countDownLatch.countDown();
            });
            thread.setName("TEST[" + i + "]");
            thread.start();
        }
        countDownLatch.await();
        System.out.println(TEXT_IDS.size());
    }
}

