/*
 * Decompiled with CFR 0.152.
 */
package com.v1ok.uuid;

import com.v1ok.uuid.IDGenerate;
import com.v1ok.uuid.property.GenerateType;
import com.v1ok.uuid.snowflake.GenerateImpl;

public final class IDGenerateBuilder {
    private GenerateType type;
    private long workerId = 1L;
    private long dataCenterId = 1L;
    private long epoch = 1555664758384L;
    private int base = 16;

    private IDGenerateBuilder(GenerateType type) {
        this.type = type;
    }

    public static IDGenerateBuilder builder(GenerateType type) {
        return new IDGenerateBuilder(type);
    }

    public IDGenerate build() {
        IDGenerate generate = null;
        switch (this.type) {
            case UUID: {
                generate = new com.v1ok.uuid.java.GenerateImpl();
                break;
            }
            case SNOWFLAKE: {
                generate = new GenerateImpl(this.workerId, this.dataCenterId, this.epoch, this.base);
            }
        }
        return generate;
    }

    public IDGenerateBuilder setType(GenerateType type) {
        this.type = type;
        return this;
    }

    public IDGenerateBuilder setWorkerId(long workerId) {
        this.workerId = workerId;
        return this;
    }

    public IDGenerateBuilder setDataCenterId(long dataCenterId) {
        this.dataCenterId = dataCenterId;
        return this;
    }

    public IDGenerateBuilder setEpoch(long epoch) {
        this.epoch = epoch;
        return this;
    }

    public IDGenerateBuilder setBase(int base) {
        this.base = base;
        return this;
    }
}

