/*
 * Decompiled with CFR 0.152.
 */
package com.v1ok.uuid.util;

public class NumericConvertUtil {
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

    public static String toOtherBaseString(long n, int base) {
        NumericConvertUtil.validate(base);
        long num = 0L;
        num = n < 0L ? 0xFFFFFFFEL + n + 2L : n;
        char[] buf = new char[64];
        int charPos = 64;
        while (num / (long)base > 0L) {
            buf[--charPos] = digits[(int)(num % (long)base)];
            num /= (long)base;
        }
        buf[--charPos] = digits[(int)(num % (long)base)];
        return new String(buf, charPos, 64 - charPos);
    }

    public static long toDecimalism(String str, int base) {
        NumericConvertUtil.validate(base);
        char[] buf = new char[str.length()];
        str.getChars(0, str.length(), buf, 0);
        long num = 0L;
        block0: for (int i = 0; i < buf.length; ++i) {
            for (int j = 0; j < digits.length; ++j) {
                if (digits[j] != buf[i]) continue;
                num = (long)((double)num + (double)j * Math.pow(base, buf.length - i - 1));
                continue block0;
            }
        }
        return num;
    }

    private static void validate(int base) {
        if (base < 2 || base > 36) {
            throw new IllegalArgumentException("The base must be between 2 and 36.");
        }
    }

    public static void main(String[] args) {
        System.out.println(Long.MAX_VALUE);
        System.out.println(NumericConvertUtil.toOtherBaseString(Long.MAX_VALUE, 2));
        System.out.println(NumericConvertUtil.toDecimalism("111111111111111111111111111111111111111111111111111111111111111", 2));
    }
}

