/*
 * Decompiled with CFR 0.152.
 */
package com.v1ok.uuid;

import com.v1ok.uuid.IDGenerate;
import com.v1ok.uuid.IDGenerateBuilder;
import com.v1ok.uuid.property.SnowflakeProperties;
import com.v1ok.uuid.property.TypeProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan
@EnableConfigurationProperties(value={SnowflakeProperties.class, TypeProperties.class})
public class AutoConfig {
    @Autowired
    SnowflakeProperties snowflakeProperties;
    @Autowired
    TypeProperties typeProperties;

    @Bean
    @ConditionalOnExpression(value="'${uuid.type:null}' != 'null'")
    public IDGenerate snowflake() {
        long workerId = this.snowflakeProperties.getWorkerId();
        long dataCenterId = this.snowflakeProperties.getDataCenterId();
        long epoch = this.snowflakeProperties.getEpoch();
        int base = this.snowflakeProperties.getBase();
        return IDGenerateBuilder.builder(this.typeProperties.getType()).setWorkerId(workerId).setDataCenterId(dataCenterId).setEpoch(epoch).setBase(base).build();
    }
}

