/*
 * Decompiled with CFR 0.152.
 */
package com.v1ok.uuid.snowflake;

import com.v1ok.uuid.IDGenerate;
import com.v1ok.uuid.util.NumericConvertUtil;

public class GenerateImpl
implements IDGenerate {
    public static final long TIME_WHEN_EPOCH = 1542444628916L;
    public static final int TO_STRING_BASE = 16;
    private final long sequenceBits = 12L;
    private final long sequenceMask = 4095L;
    private long twepoch;
    private long workerIdBits = 5L;
    private long dataCenterIdBits = 5L;
    private long workerIdShift;
    private long dataCenterIdShift;
    private long timestampLeftShift;
    private long workerId;
    private long dataCenterId;
    private long sequence = 0L;
    private long lastTimestamp = -1L;
    private int base;

    public GenerateImpl(long workerId, long dataCenterId) {
        this(workerId, dataCenterId, 1542444628916L, 16);
    }

    public GenerateImpl(long workerId, long dataCenterId, long twepoch, int base) {
        this.twepoch = twepoch;
        this.workerId = workerId;
        this.dataCenterId = dataCenterId;
        this.base = base;
        this.workerIdShift = this.sequenceBits;
        this.dataCenterIdShift = this.sequenceBits + this.workerIdBits;
        this.timestampLeftShift = this.sequenceBits + this.dataCenterIdBits;
        if (workerId > this.getMaxWorkerId() || workerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", this.getMaxWorkerId()));
        }
        if (dataCenterId > this.getMaxDateCenterId() || dataCenterId < 0L) {
            throw new IllegalArgumentException(String.format("data center Id can't be greater than %d or less than 0", this.getMaxDateCenterId()));
        }
    }

    protected long getMaxWorkerId() {
        return 0xFFFFFFFFFFFFFFFFL ^ -1L << (int)this.workerIdBits;
    }

    protected long getMaxDateCenterId() {
        return 0xFFFFFFFFFFFFFFFFL ^ -1L << (int)this.dataCenterIdBits;
    }

    @Override
    public String nextIdToString() throws InterruptedException {
        return NumericConvertUtil.toOtherBaseString(this.nextIdToLong(), this.base);
    }

    @Override
    public synchronized Long nextIdToLong() throws InterruptedException {
        long timestamp = this.timeGen();
        if (timestamp < this.lastTimestamp) {
            throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - this.twepoch << (int)this.timestampLeftShift | this.dataCenterId << (int)this.dataCenterIdShift | this.workerId << (int)this.workerIdShift | this.sequence;
    }

    protected long tilNextMillis(long lastTimestamp) throws InterruptedException {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            long sleepTime = lastTimestamp - timestamp;
            Thread.sleep(sleepTime);
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    protected long timeGen() {
        return System.currentTimeMillis();
    }

    public static void main(String[] args) throws InterruptedException {
        GenerateImpl idGenerate = new GenerateImpl(1L, 0L);
        for (int i = 0; i < 1000; ++i) {
            Long id = idGenerate.nextIdToLong();
            System.out.println(id + "  " + Long.toHexString(id));
            System.out.println(id.toString().length() + "  " + Long.toHexString(id).length());
        }
        String s = String.valueOf(Long.MAX_VALUE);
        System.out.println(s + "   " + s.length() + " " + Long.toHexString(Long.MAX_VALUE).length());
    }
}

