/*
 * Decompiled with CFR 0.152.
 */
package com.v1ok.feign.http.converter;

import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ResolvableType;
import org.springframework.http.MediaType;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;

public abstract class AbstractContextHttpMessageConverter<Context>
extends MappingJackson2HttpMessageConverter {
    private static final Logger log = LoggerFactory.getLogger(AbstractContextHttpMessageConverter.class);
    protected Class<Context> contextClass;
    protected final ObjectMapper objectMapper;

    public AbstractContextHttpMessageConverter(ObjectMapper objectMapper) {
        super(objectMapper);
        this.objectMapper = objectMapper;
        this.objectMapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
        Type genType = ((Object)((Object)this)).getClass().getGenericSuperclass();
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        this.contextClass = ResolvableType.forType((Type)params[0]).resolve();
    }

    protected boolean supports(Class<?> clazz) {
        return clazz.isAssignableFrom(this.contextClass);
    }

    public boolean canRead(Type type, Class<?> contextClass, MediaType mediaType) {
        Validate.notNull((Object)type, (String)"The Type is not null", (Object[])new Object[0]);
        if (contextClass != null) {
            return this.supports(contextClass);
        }
        Class resolve = ResolvableType.forType((Type)type).resolve();
        return this.supports(resolve);
    }
}

