/*
 * Decompiled with CFR 0.152.
 */
package com.v1ok.feign.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class NumberAdapter
implements JsonSerializer<Number>,
JsonDeserializer<Number> {
    public Number deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        String string = json.getAsString();
        if (StringUtils.isBlank((CharSequence)string)) {
            return null;
        }
        if (NumberUtils.isCreatable((String)string)) {
            return json.getAsNumber();
        }
        return this.convert(string);
    }

    public JsonElement serialize(Number src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive(src);
    }

    private Number convert(String str) {
        String notNumberStr = RegExUtils.removeAll((String)str, (String)"[^[\\d]+[.][\\d]+]");
        String numberStr = StringUtils.replace((String)str, (String)notNumberStr, (String)"");
        if (StringUtils.isBlank((CharSequence)numberStr)) {
            return null;
        }
        return NumberUtils.createNumber((String)numberStr);
    }
}

