/*
 * Decompiled with CFR 0.152.
 */
package com.v1ok.feign.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.FastDateFormat;

public class DateAdapter
implements JsonSerializer<Date>,
JsonDeserializer<Date> {
    private static final String[] PATTERN = new String[]{"yyyy-MM-dd hh:mm:ss", "yyyy-MM-dd'T'HH:mm:ssXX"};

    public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        String value = json.getAsString();
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        if (NumberUtils.isCreatable((String)value)) {
            return new Date(NumberUtils.createLong((String)value));
        }
        return this.parse(value);
    }

    public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive(FastDateFormat.getInstance((String)PATTERN[1]).format(src));
    }

    private Date parse(String dateStr) {
        for (String parStr : PATTERN) {
            try {
                FastDateFormat fastDateFormat = FastDateFormat.getInstance((String)parStr);
                return fastDateFormat.parse(dateStr);
            }
            catch (ParseException parseException) {
            }
        }
        try {
            return DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse(dateStr);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static void main(String[] args) throws ParseException {
        String source = "2020-08-17T22:19:11+0800";
        String format1 = FastDateFormat.getInstance((String)"").format(new Date());
        System.out.println(format1);
    }
}

