/*
 * Decompiled with CFR 0.152.
 */
package com.v1ok.feign;

import com.google.gson.Gson;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import lombok.NonNull;
import org.apache.commons.lang3.Validate;
import org.springframework.core.ResolvableType;
import org.springframework.http.MediaType;
import org.springframework.http.converter.json.GsonHttpMessageConverter;

public abstract class AbstractGsonHttpMessageConverter<Context>
extends GsonHttpMessageConverter {
    protected Class<Context> contextClass;

    public AbstractGsonHttpMessageConverter(@NonNull Gson gson) {
        super(gson);
        if (gson == null) {
            throw new NullPointerException("gson is marked non-null but is null");
        }
        Type genType = ((Object)((Object)this)).getClass().getGenericSuperclass();
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        this.contextClass = ResolvableType.forType((Type)params[0]).resolve();
    }

    protected boolean supports(Class<?> clazz) {
        return clazz.isAssignableFrom(this.contextClass);
    }

    public boolean canRead(Type type, Class<?> contextClass, MediaType mediaType) {
        Validate.notNull((Object)type, (String)"The Type is not null", (Object[])new Object[0]);
        if (contextClass != null) {
            return this.supports(contextClass);
        }
        Class resolve = ResolvableType.forType((Type)type).resolve();
        return this.supports(resolve);
    }

    public boolean canWrite(Type type, Class<?> clazz, MediaType mediaType) {
        return false;
    }
}

